/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.maintenance;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.jetbrains.annotations.Nullable;

public class MaintenanceRebuildIndexUtils {
    public static final String INDEX_REBUILD_MNTC_TASK_NAME = "indexRebuildMaintenanceTask";
    public static final String INDEX_REBUILD_PARAMETER_SEPARATOR = "|";
    public static final String INDEX_REBUILD_PARAMETER_SEPARATOR_REGEX = "\\|";
    private static final String TASK_DESCRIPTION = "Corrupted index found";
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();

    public static List<MaintenanceRebuildIndexTarget> parseMaintenanceTaskParameters(@Nullable String parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        String[] parametersArray = parameters.split(INDEX_REBUILD_PARAMETER_SEPARATOR_REGEX);
        if (parametersArray.length == 0) {
            return Collections.emptyList();
        }
        assert (parametersArray.length % 2 == 0);
        ArrayList<MaintenanceRebuildIndexTarget> params = new ArrayList<MaintenanceRebuildIndexTarget>(parametersArray.length / 2);
        for (int i = 0; i < parametersArray.length; i += 2) {
            String idxNameEncoded = parametersArray[i + 1];
            String idxName = new String(DECODER.decode(idxNameEncoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            params.add(new MaintenanceRebuildIndexTarget(Integer.parseInt(parametersArray[i]), idxName));
        }
        return params;
    }

    public static MaintenanceTask toMaintenanceTask(int cacheId, String idxName) {
        String encodedIdxName = ENCODER.encodeToString(idxName.getBytes(StandardCharsets.UTF_8));
        return new MaintenanceTask(INDEX_REBUILD_MNTC_TASK_NAME, TASK_DESCRIPTION, cacheId + INDEX_REBUILD_PARAMETER_SEPARATOR + encodedIdxName);
    }

    public static MaintenanceTask toMaintenanceTask(Map<Integer, Set<String>> cacheToIndexes) {
        String parameters = cacheToIndexes.entrySet().stream().flatMap(entry -> {
            Integer cacheId = (Integer)entry.getKey();
            Set indexes = (Set)entry.getValue();
            return indexes.stream().map(index -> {
                String encodedIdxName = ENCODER.encodeToString(index.getBytes(StandardCharsets.UTF_8));
                return cacheId + INDEX_REBUILD_PARAMETER_SEPARATOR + encodedIdxName;
            });
        }).collect(Collectors.joining(INDEX_REBUILD_PARAMETER_SEPARATOR));
        return new MaintenanceTask(INDEX_REBUILD_MNTC_TASK_NAME, TASK_DESCRIPTION, parameters);
    }

    public static MaintenanceTask mergeTasks(MaintenanceTask oldTask, MaintenanceTask newTask) {
        String newTaskParams;
        assert (Objects.equals(INDEX_REBUILD_MNTC_TASK_NAME, oldTask.name()));
        assert (Objects.equals(TASK_DESCRIPTION, oldTask.description()));
        assert (Objects.equals(oldTask.name(), newTask.name()));
        assert (Objects.equals(oldTask.description(), newTask.description()));
        String oldTaskParams = oldTask.parameters();
        if (oldTaskParams.contains(newTaskParams = newTask.parameters())) {
            return oldTask;
        }
        String mergedParams = oldTaskParams + INDEX_REBUILD_PARAMETER_SEPARATOR + newTaskParams;
        return new MaintenanceTask(oldTask.name(), oldTask.description(), mergedParams);
    }
}

