/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.check_indexes_inline_size;

import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.commandline.cache.check_indexes_inline_size.CheckIndexInlineSizesResult;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CheckIndexInlineSizesTask
extends VisorMultiNodeTask<NoArg, CheckIndexInlineSizesResult, CheckIndexInlineSizesResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<NoArg, CheckIndexInlineSizesResult> job(NoArg arg) {
        return new CheckIndexInlineSizesJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected CheckIndexInlineSizesResult reduce0(List<ComputeJobResult> results) {
        CheckIndexInlineSizesResult res = new CheckIndexInlineSizesResult();
        boolean foundEx = false;
        for (ComputeJobResult jobResult : results) {
            if (jobResult.getException() == null) {
                res.merge((CheckIndexInlineSizesResult)jobResult.getData());
                continue;
            }
            foundEx = true;
            break;
        }
        if (foundEx) {
            IgniteException compoundEx = new IgniteException();
            for (ComputeJobResult jobResult : results) {
                if (jobResult.getException() == null) continue;
                compoundEx.addSuppressed(jobResult.getException());
            }
            throw compoundEx;
        }
        return res;
    }

    private static class CheckIndexInlineSizesJob
    extends VisorJob<NoArg, CheckIndexInlineSizesResult> {
        private static final long serialVersionUID = 0L;

        protected CheckIndexInlineSizesJob(@Nullable NoArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected CheckIndexInlineSizesResult run(@Nullable NoArg arg) throws IgniteException {
            Map<String, Integer> indexNameToInlineSize = this.ignite.context().query().secondaryIndexesInlineSize();
            CheckIndexInlineSizesResult res = new CheckIndexInlineSizesResult();
            res.addResult(this.ignite.localNode().id(), indexNameToInlineSize);
            return res;
        }
    }
}

