/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.collision;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.collision.CollisionContext;
import org.apache.ignite.spi.collision.CollisionExternalListener;
import org.apache.ignite.spi.collision.CollisionJobContext;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.jetbrains.annotations.Nullable;

public class GridCollisionManager
extends GridManagerAdapter<CollisionSpi> {
    private final AtomicReference<CollisionExternalListener> extLsnr = new AtomicReference();

    public GridCollisionManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new CollisionSpi[]{ctx.config().getCollisionSpi()});
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        if (this.enabled()) {
            ((CollisionSpi)this.getSpi()).setExternalCollisionListener(new CollisionExternalListener(){

                @Override
                public void onExternalCollision() {
                    CollisionExternalListener lsnr = (CollisionExternalListener)GridCollisionManager.this.extLsnr.get();
                    if (lsnr != null) {
                        lsnr.onExternalCollision();
                    }
                }
            });
        } else {
            this.log.info("Collision resolution is disabled (all jobs will be activated upon arrival).");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        if (this.enabled()) {
            ((CollisionSpi)this.getSpi()).setExternalCollisionListener(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public void unsetCollisionExternalListener() {
        if (this.enabled()) {
            ((CollisionSpi)this.getSpi()).setExternalCollisionListener(null);
        }
    }

    public void setCollisionExternalListener(@Nullable CollisionExternalListener lsnr) {
        if (this.enabled()) {
            if (lsnr != null && !this.extLsnr.compareAndSet(null, lsnr)) {
                assert (false) : "Collision external listener has already been set (perhaps need to add support for multiple listeners)";
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Successfully set external collision listener: " + lsnr);
            }
        }
    }

    public void onCollision(final Collection<CollisionJobContext> waitJobs, final Collection<CollisionJobContext> activeJobs, final Collection<CollisionJobContext> heldJobs) {
        if (this.enabled()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolving job collisions [waitJobs=" + waitJobs + ", activeJobs=" + activeJobs + ']');
            }
            ((CollisionSpi)this.getSpi()).onCollision(new CollisionContext(){

                @Override
                public Collection<CollisionJobContext> activeJobs() {
                    return activeJobs;
                }

                @Override
                public Collection<CollisionJobContext> waitingJobs() {
                    return waitJobs;
                }

                @Override
                public Collection<CollisionJobContext> heldJobs() {
                    return heldJobs;
                }
            });
        }
    }
}

