/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload.pipeline;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;

public class CsvLineProcessorBlock
extends PipelineBlock<String, String[]> {
    public static final String[] EMPTY_STR_ARRAY = new String[0];
    private final char fldDelim;
    private final char quoteChars;
    private final String nullString;
    private final boolean trim;
    private int line = 0;
    private int symbol = 0;

    public CsvLineProcessorBlock(BulkLoadCsvFormat format) {
        this.fldDelim = format.fieldSeparator().toString().charAt(0);
        this.quoteChars = format.quoteChars().charAt(0);
        this.nullString = format.nullString();
        this.trim = format.trim();
    }

    @Override
    public void accept(String input, boolean isLastPortion) throws IgniteCheckedException {
        char c;
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder currentField = new StringBuilder(256);
        ReaderState state = ReaderState.IDLE;
        int length = input.length();
        int copy = 0;
        int current = 0;
        int n = -1;
        int copyStart = 0;
        boolean quotesMatched = true;
        ++this.line;
        this.symbol = 0;
        while (true) {
            if (current == length) {
                if (!quotesMatched) {
                    throw new IgniteCheckedException(new SQLException("Unmatched quote found at the end of line " + this.line + ", symbol " + this.symbol));
                }
                if (copy > 0) {
                    currentField.append(input, copyStart, copyStart + copy);
                }
                break;
            }
            char c2 = input.charAt(current++);
            ++this.symbol;
            if (state == ReaderState.QUOTED) {
                if (c2 == this.quoteChars) {
                    state = ReaderState.IDLE;
                    boolean bl = quotesMatched = !quotesMatched;
                    if (copy > 0) {
                        currentField.append(input, copyStart, copyStart + copy);
                        copy = 0;
                    }
                    copyStart = current;
                } else {
                    ++copy;
                }
            } else if (c2 == this.fldDelim) {
                if (copy > 0) {
                    currentField.append(input, copyStart, copyStart + copy);
                    copy = 0;
                }
                this.addField(fields, currentField, c == this.quoteChars);
                currentField = new StringBuilder();
                copyStart = current;
                state = ReaderState.IDLE;
            } else if (c2 == this.quoteChars && state != ReaderState.UNQUOTED) {
                state = ReaderState.QUOTED;
                boolean bl = quotesMatched = !quotesMatched;
                if (c == this.quoteChars) {
                    ++copy;
                } else {
                    copyStart = current;
                }
            } else {
                if (c2 == this.quoteChars) {
                    if (state == ReaderState.UNQUOTED) {
                        throw new IgniteCheckedException(new SQLException("Unexpected quote in the field, line " + this.line + ", symbol " + this.symbol));
                    }
                    quotesMatched = !quotesMatched;
                }
                ++copy;
                if (state == ReaderState.IDLE) {
                    state = ReaderState.UNQUOTED;
                }
            }
            c = c2;
        }
        this.addField(fields, currentField, c == this.quoteChars);
        this.nextBlock.accept(fields.toArray(EMPTY_STR_ARRAY), isLastPortion);
    }

    private void addField(List<String> fields, StringBuilder fieldVal, boolean quoted) {
        String val = this.trim ? fieldVal.toString().trim() : fieldVal.toString();
        fields.add(val.equals(this.nullString) ? null : val);
    }

    private static enum ReaderState {
        IDLE,
        UNQUOTED,
        QUOTED;

    }
}

