/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtLockResponse
extends GridDistributedLockResponse {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> nearEvicted;
    private IgniteUuid miniId;
    @GridToStringInclude
    @GridDirectCollection(value=int.class)
    private Collection<Integer> invalidParts;
    @GridDirectCollection(value=GridCacheEntryInfo.class)
    private List<GridCacheEntryInfo> preloadEntries;

    public GridDhtLockResponse() {
    }

    public GridDhtLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, IgniteUuid miniId, int cnt, boolean addDepInfo) {
        super(cacheId, lockVer, futId, cnt, addDepInfo);
        assert (miniId != null);
        this.miniId = miniId;
    }

    public GridDhtLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, IgniteUuid miniId, Throwable err, boolean addDepInfo) {
        super(cacheId, lockVer, futId, err, addDepInfo);
        assert (miniId != null);
        this.miniId = miniId;
    }

    public Collection<IgniteTxKey> nearEvicted() {
        return this.nearEvicted;
    }

    public void nearEvicted(Collection<IgniteTxKey> nearEvicted) {
        this.nearEvicted = nearEvicted;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public void addInvalidPartition(int part) {
        if (this.invalidParts == null) {
            this.invalidParts = new HashSet<Integer>();
        }
        this.invalidParts.add(part);
    }

    public Collection<Integer> invalidPartitions() {
        return this.invalidParts == null ? Collections.emptySet() : this.invalidParts;
    }

    public void addPreloadEntry(GridCacheEntryInfo info) {
        if (this.preloadEntries == null) {
            this.preloadEntries = new ArrayList<GridCacheEntryInfo>();
        }
        this.preloadEntries.add(info);
    }

    public Collection<GridCacheEntryInfo> preloadEntries() {
        return this.preloadEntries == null ? Collections.emptyList() : this.preloadEntries;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                key.prepareMarshal(cctx);
            }
        }
        if (this.preloadEntries != null) {
            this.marshalInfos(this.preloadEntries, cctx.shared(), cctx.cacheObjectContext());
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                key.finishUnmarshal(cctx, ldr);
            }
        }
        if (this.preloadEntries != null) {
            this.unmarshalInfos(this.preloadEntries, ctx.cacheContext(this.cacheId), ldr);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 11: {
                if (!writer.writeCollection("invalidParts", this.invalidParts, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeCollection("nearEvicted", this.nearEvicted, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeCollection("preloadEntries", this.preloadEntries, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 11: {
                this.invalidParts = reader.readCollection("invalidParts", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.nearEvicted = reader.readCollection("nearEvicted", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.preloadEntries = (List)reader.readCollection("preloadEntries", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtLockResponse.class);
    }

    @Override
    public short directType() {
        return 31;
    }

    @Override
    public byte fieldsCount() {
        return 15;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtLockResponse.class, this, super.toString());
    }
}

