/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.jetbrains.annotations.Nullable;

public abstract class ClientListenerAbstractConnectionContext
implements ClientListenerConnectionContext {
    protected final GridKernalContext ctx;
    protected final GridNioSession ses;
    private SecurityContext secCtx;
    private long connId;
    protected Map<String, String> userAttrs;
    private String clientDesc;

    protected ClientListenerAbstractConnectionContext(GridKernalContext ctx, GridNioSession ses, long connId) {
        this.ctx = ctx;
        this.connId = connId;
        this.ses = ses;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    @Override
    @Nullable
    public SecurityContext securityContext() {
        return this.secCtx;
    }

    @Override
    public long connectionId() {
        return this.connId;
    }

    protected void authenticate(GridNioSession ses, String user, String pwd) throws IgniteCheckedException {
        if (!this.ctx.security().enabled()) {
            return;
        }
        SecurityCredentials cred = new SecurityCredentials(user, pwd);
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(UUID.randomUUID());
        authCtx.nodeAttributes(F.isEmpty(this.userAttrs) ? Collections.emptyMap() : this.userAttrs);
        authCtx.credentials(cred);
        authCtx.address(ses.remoteAddress());
        authCtx.certificates(ses.certificates());
        this.secCtx = this.ctx.security().authenticate(authCtx);
        if (this.secCtx == null) {
            throw new IgniteAccessControlException(String.format("The user name or password is incorrect [userName=%s]", user));
        }
    }

    @Override
    public void onDisconnected() {
        if (this.ctx.security().enabled()) {
            this.ctx.security().onSessionExpired(this.secCtx.subject().id());
        }
    }

    protected void initClientDescriptor(String prefix) {
        this.clientDesc = prefix + ":" + this.ses.remoteAddress().getHostString() + ":" + this.ses.remoteAddress().getPort();
        if (this.secCtx != null) {
            this.clientDesc = this.clientDesc + "@" + this.secCtx.subject().login();
        }
    }

    public String clientDescriptor() {
        return this.clientDesc;
    }

    @Override
    public Map<String, String> attributes() {
        return F.isEmpty(this.userAttrs) ? Collections.emptyMap() : Collections.unmodifiableMap(this.userAttrs);
    }
}

