/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.util.typedef.F;

public class GridFileUtils {
    private static final int COPY_BUFFER_SIZE = 0x100000;

    public static void copy(FileIO src, FileIO dst, long maxBytes) throws IOException {
        assert (maxBytes >= 0L);
        byte[] buf = new byte[0x100000];
        for (long bytes = Math.min(src.size(), maxBytes); bytes > 0L; bytes -= (long)dst.writeFully(buf, 0, src.readFully(buf, 0, (int)Math.min(0x100000L, bytes)))) {
        }
        dst.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FileIOFactory srcFactory, File src, FileIOFactory dstFactory, File dst, long maxBytes) throws IOException {
        boolean err = true;
        try (FileIO dstIO = dstFactory.create(dst, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
             FileIO srcIO = srcFactory.create(src, StandardOpenOption.READ);){
            GridFileUtils.copy(srcIO, dstIO, maxBytes);
            err = false;
        }
        finally {
            if (err) {
                dst.delete();
            }
        }
    }

    public static void ensureHardLinkAvailable(Path path1, Path path2) throws IgniteCheckedException {
        try {
            FileStore fs1 = Files.getFileStore(path1);
            FileStore fs2 = Files.getFileStore(path2);
            if (!F.eq(fs1.name(), fs2.name())) {
                throw new IgniteCheckedException("Paths are not stored at the same device or partition. Creating hard links is not available. [path1=" + path1 + ", path2=" + path2 + ", fileStoreName1=" + fs1.name() + ", fileStoreName2=" + fs2.name() + ']');
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Unable to check file stores.", e);
        }
    }
}

