/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Collections;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SystemSession
extends SessionImpl {
    private static Logger log = LoggerFactory.getLogger((Class)SystemSession.class);

    static SystemSession create(RepositoryImpl rep, WorkspaceConfig wspConfig) throws RepositoryException {
        HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
        principals.add(new SystemPrincipal());
        Subject subject = new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
        return new SystemSession(rep, subject, wspConfig);
    }

    private SystemSession(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(rep, subject, wspConfig);
    }

    protected AccessManager createAccessManager(Subject subject, HierarchyManager hierMgr) throws AccessDeniedException, RepositoryException {
        return new SystemAccessManager();
    }

    private class SystemAccessManager
    implements AccessManager {
        SystemAccessManager() {
        }

        public void init(AMContext context) throws AccessDeniedException, Exception {
        }

        public void close() throws Exception {
        }

        public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        }

        public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
            return true;
        }

        public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
            return true;
        }
    }
}

