/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((Class)TransactionContext.class);
    private final InternalXAResource[] resources;
    private final int timeout;
    private final Map attributes = new HashMap();
    private int status;

    public TransactionContext(InternalXAResource[] resources, int timeout) {
        this.resources = resources;
        this.timeout = timeout;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public synchronized void prepare() throws XAException {
        this.status = 7;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            try {
                this.resources[i].prepare(this);
                continue;
            }
            catch (TransactionException e) {
                txe = e;
                break;
            }
        }
        this.afterOperation();
        this.status = 2;
        if (txe != null) {
            try {
                this.rollback();
            }
            catch (XAException e) {
                // empty catch block
            }
            XAException e = new XAException(104);
            e.initCause(txe);
            throw e;
        }
        new Thread((Runnable)this, "RollbackThread").start();
    }

    public synchronized void commit() throws XAException {
        if (this.status == 4) {
            throw new XAException(106);
        }
        this.status = 8;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            if (txe != null) {
                try {
                    resource.rollback(this);
                }
                catch (TransactionException e) {
                    log.warn("Unable to rollback changes on " + resource, (Throwable)e);
                }
                continue;
            }
            try {
                resource.commit(this);
                continue;
            }
            catch (TransactionException e) {
                txe = e;
            }
        }
        this.afterOperation();
        this.status = 3;
        if (txe != null) {
            XAException e = new XAException(104);
            e.initCause(txe);
            throw e;
        }
    }

    public synchronized void rollback() throws XAException {
        if (this.status == 4) {
            throw new XAException(106);
        }
        this.status = 9;
        this.beforeOperation();
        int errors = 0;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            try {
                resource.rollback(this);
                continue;
            }
            catch (TransactionException e) {
                log.warn("Unable to rollback changes on " + resource, (Throwable)e);
                ++errors;
            }
        }
        this.afterOperation();
        this.status = 4;
        if (errors != 0) {
            throw new XAException(104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(this.timeout * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TransactionContext transactionContext = this;
        synchronized (transactionContext) {
            if (this.status == 2) {
                try {
                    this.rollback();
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                log.warn("Transaction rolled back because timeout expired.");
            }
        }
    }

    private void beforeOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].beforeOperation(this);
        }
    }

    private void afterOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].afterOperation(this);
        }
    }
}

