/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.NoSuchWorkspaceException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.XAItemStateManager;

public class XAWorkspace
extends WorkspaceImpl {
    private static final String ATTR_NAME_WORKSPACE_INFO = RepositoryImpl.WorkspaceInfo.class.getName();

    protected XAWorkspace(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        super(wspConfig, stateMgr, rep, session);
    }

    protected LocalItemStateManager createItemStateManager(SharedItemStateManager shared) {
        return new XAItemStateManager(shared, this);
    }

    protected InternalXAResource getXAResourceBegin() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) throws TransactionException {
                try {
                    RepositoryImpl.WorkspaceInfo wspInfo = XAWorkspace.this.rep.getWorkspaceInfo(XAWorkspace.this.wspConfig.getName());
                    wspInfo.lockAcquire();
                    tx.setAttribute(ATTR_NAME_WORKSPACE_INFO, wspInfo);
                }
                catch (NoSuchWorkspaceException e) {
                    throw new TransactionException("Error while preparing for transaction", e);
                }
            }

            public void commit(TransactionContext tx) {
            }

            public void rollback(TransactionContext tx) {
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }

    protected InternalXAResource getXAResourceEnd() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
            }

            public void commit(TransactionContext tx) {
                RepositoryImpl.WorkspaceInfo wspInfo = (RepositoryImpl.WorkspaceInfo)tx.getAttribute(ATTR_NAME_WORKSPACE_INFO);
                if (wspInfo != null) {
                    wspInfo.lockRelease();
                    tx.removeAttribute(ATTR_NAME_WORKSPACE_INFO);
                }
            }

            public void rollback(TransactionContext tx) {
                RepositoryImpl.WorkspaceInfo wspInfo = (RepositoryImpl.WorkspaceInfo)tx.getAttribute(ATTR_NAME_WORKSPACE_INFO);
                if (wspInfo != null) {
                    wspInfo.lockRelease();
                    tx.removeAttribute(ATTR_NAME_WORKSPACE_INFO);
                }
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }
}

