/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;

public class DB2FileSystem
extends DbFileSystem {
    public DB2FileSystem() {
        this.schema = "db2";
        this.driver = "com.ibm.db2.jcc.DB2Driver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    protected List initPreparedStatements() throws SQLException {
        LinkedList<PreparedStatement> stmts = new LinkedList<PreparedStatement>();
        this.insertFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)");
        stmts.add(this.insertFileStmt);
        this.insertFolderStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, 0)");
        stmts.add(this.insertFolderStmt);
        this.updateDataStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
        stmts.add(this.updateDataStmt);
        this.updateLastModifiedStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
        stmts.add(this.updateLastModifiedStmt);
        this.selectExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
        stmts.add(this.selectExistStmt);
        this.selectFileExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
        stmts.add(this.selectFileExistStmt);
        this.selectFolderExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is null");
        stmts.add(this.selectFolderExistStmt);
        this.selectFileNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
        stmts.add(this.selectFileNamesStmt);
        this.selectFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is null");
        stmts.add(this.selectFolderNamesStmt);
        this.selectFileAndFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?");
        stmts.add(this.selectFileAndFolderNamesStmt);
        this.selectChildCountStmt = this.con.prepareStatement("select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  ");
        stmts.add(this.selectChildCountStmt);
        this.selectDataStmt = this.con.prepareStatement("select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
        stmts.add(this.selectDataStmt);
        this.selectLastModifiedStmt = this.con.prepareStatement("select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
        stmts.add(this.selectLastModifiedStmt);
        this.selectLengthStmt = this.con.prepareStatement("select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
        stmts.add(this.selectLengthStmt);
        this.deleteFileStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
        stmts.add(this.deleteFileStmt);
        this.deleteFolderStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ");
        stmts.add(this.deleteFolderStmt);
        this.copyFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select cast(? as varchar(745)), cast(? as varchar(255)), FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
        stmts.add(this.copyFileStmt);
        this.copyFilesStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select cast(? as varchar(745)), FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
        stmts.add(this.copyFilesStmt);
        return stmts;
    }
}

