/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleFileSystem
extends DbFileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)OracleFileSystem.class);

    public OracleFileSystem() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            this.initConnection();
            this.checkSchema();
            this.insertFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)");
            this.insertFolderStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, nvl(?, ' '), ?, null)");
            this.updateDataStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null");
            this.updateLastModifiedStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null");
            this.selectExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')");
            this.selectFileExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
            this.selectFolderExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null");
            this.selectFileNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null");
            this.selectFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' ' " + "and FSENTRY_LENGTH is null");
            this.selectFileAndFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' '");
            this.selectChildCountStmt = this.con.prepareStatement("select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  " + "and FSENTRY_NAME != ' '");
            this.selectDataStmt = this.con.prepareStatement("select nvl(FSENTRY_DATA, empty_blob()) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
            this.selectLastModifiedStmt = this.con.prepareStatement("select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')");
            this.selectLengthStmt = this.con.prepareStatement("select nvl(FSENTRY_LENGTH, 0) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
            this.deleteFileStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
            this.deleteFolderStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ");
            this.copyFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, ?, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
            this.copyFilesStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null");
            this.verifyRootExists();
            this.initialized = true;
        }
        catch (Exception e) {
            String msg = "failed to initialize file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }
}

