/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jackrabbit.core.jndi.BindableRepository;
import org.apache.jackrabbit.core.jndi.BindableRepositoryFactory;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static void registerRepository(Context ctx, String name, String configFilePath, String repHomeDir, boolean overwrite) throws NamingException, RepositoryException {
        BindableRepository obj = BindableRepositoryFactory.createInstance(configFilePath, repHomeDir);
        if (overwrite) {
            ctx.rebind(name, (Object)obj);
        } else {
            ctx.bind(name, (Object)obj);
        }
    }

    public static void unregisterRepository(Context ctx, String name) throws NamingException {
        ((BindableRepository)ctx.lookup(name)).shutdown();
        ctx.unbind(name);
    }
}

