/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeImpl
implements NodeType {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeImpl.class);
    private final NodeTypeDef ntd;
    private final EffectiveNodeType ent;
    private final NodeTypeManagerImpl ntMgr;
    private final NamespaceResolver nsResolver;

    NodeTypeImpl(EffectiveNodeType ent, NodeTypeDef ntd, NodeTypeManagerImpl ntMgr, NamespaceResolver nsResolver) {
        this.ent = ent;
        this.ntMgr = ntMgr;
        this.nsResolver = nsResolver;
        this.ntd = ntd;
    }

    public boolean isDerivedFrom(QName nodeTypeName) {
        return !nodeTypeName.equals(this.ntd.getName()) && this.ent.includesNodeType(nodeTypeName);
    }

    public NodeTypeDef getDefinition() {
        return (NodeTypeDef)this.ntd.clone();
    }

    public NodeDefinition[] getAutoCreatedNodeDefinitions() {
        NodeDef[] cnda = this.ent.getAutoCreateNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getAutoCreatedPropertyDefinitions() {
        PropDef[] pda = this.ent.getAutoCreatePropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public PropertyDefinition[] getMandatoryPropertyDefinitions() {
        PropDef[] pda = this.ent.getMandatoryPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public NodeDefinition[] getMandatoryNodeDefinitions() {
        NodeDef[] cnda = this.ent.getMandatoryNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public QName getQName() {
        return this.ntd.getName();
    }

    public NodeType[] getInheritedSupertypes() {
        QName[] ntNames = this.ntd.getSupertypes();
        HashSet<QName> declared = new HashSet<QName>();
        for (int i = 0; i < ntNames.length; ++i) {
            declared.add(ntNames[i]);
        }
        ntNames = this.ent.getInheritedNodeTypes();
        ArrayList<NodeTypeImpl> inherited = new ArrayList<NodeTypeImpl>();
        for (int i = 0; i < ntNames.length; ++i) {
            if (declared.contains(ntNames[i])) continue;
            try {
                inherited.add(this.ntMgr.getNodeType(ntNames[i]));
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return inherited.toArray(new NodeType[inherited.size()]);
    }

    public String getName() {
        try {
            return NameFormat.format(this.ntd.getName(), this.nsResolver);
        }
        catch (NoPrefixDeclaredException npde) {
            log.error("encountered unregistered namespace in node type name", (Throwable)npde);
            return this.ntd.getName().toString();
        }
    }

    public String getPrimaryItemName() {
        try {
            QName piName = this.ntd.getPrimaryItemName();
            if (piName != null) {
                return NameFormat.format(piName, this.nsResolver);
            }
            return null;
        }
        catch (NoPrefixDeclaredException npde) {
            log.error("encountered unregistered namespace in name of primary item", (Throwable)npde);
            return this.ntd.getName().toString();
        }
    }

    public boolean isMixin() {
        return this.ntd.isMixin();
    }

    public boolean isNodeType(String nodeTypeName) {
        QName ntName;
        try {
            ntName = NameFormat.parse(nodeTypeName, this.nsResolver);
        }
        catch (IllegalNameException ine) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)ine);
            return false;
        }
        catch (UnknownPrefixException upe) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)upe);
            return false;
        }
        return this.getQName().equals(ntName) || this.isDerivedFrom(ntName);
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public NodeType[] getSupertypes() {
        QName[] ntNames = this.ent.getInheritedNodeTypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        NodeDef[] cnda = this.ent.getAllNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        PropDef[] pda = this.ent.getAllPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }

    public NodeType[] getDeclaredSupertypes() {
        QName[] ntNames = this.ntd.getSupertypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDef[] cnda = this.ntd.getChildNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i].getId());
        }
        return nodeDefs;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            InternalValue internalValue;
            PropDef def;
            QName name = NameFormat.parse(propertyName, this.nsResolver);
            try {
                def = this.ent.getApplicablePropertyDef(name, value.getType(), false);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, false);
            }
            if (def.isProtected()) {
                return false;
            }
            if (def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? def.getRequiredType() : value.getType();
            if (targetType != value.getType()) {
                Value targetVal = ValueHelper.convert(value, targetType, ValueFactoryImpl.getInstance());
                internalValue = InternalValue.create(targetVal, this.nsResolver);
            } else {
                internalValue = InternalValue.create(value, this.nsResolver);
            }
            EffectiveNodeType.checkSetPropertyValueConstraints(def, new InternalValue[]{internalValue});
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            PropDef def;
            QName name = NameFormat.parse(propertyName, this.nsResolver);
            int type = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (type == 0) {
                    type = values[i].getType();
                    continue;
                }
                if (type == values[i].getType()) continue;
                return false;
            }
            try {
                def = this.ent.getApplicablePropertyDef(name, type, true);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, true);
            }
            if (def.isProtected()) {
                return false;
            }
            if (!def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != type ? def.getRequiredType() : type;
            ArrayList<InternalValue> list = new ArrayList<InternalValue>();
            for (int i = 0; i < values.length; ++i) {
                InternalValue internalValue;
                if (values[i] == null) continue;
                if (targetType != type) {
                    Value targetVal = ValueHelper.convert(values[i], targetType, ValueFactoryImpl.getInstance());
                    internalValue = InternalValue.create(targetVal, this.nsResolver);
                } else {
                    internalValue = InternalValue.create(values[i], this.nsResolver);
                }
                list.add(internalValue);
            }
            InternalValue[] internalValues = list.toArray(new InternalValue[list.size()]);
            EffectiveNodeType.checkSetPropertyValueConstraints(def, internalValues);
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            this.ent.checkAddNodeConstraints(NameFormat.parse(childNodeName, this.nsResolver));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            this.ent.checkAddNodeConstraints(NameFormat.parse(childNodeName, this.nsResolver), NameFormat.parse(nodeTypeName, this.nsResolver), this.ntMgr.getNodeTypeRegistry());
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        try {
            this.ent.checkRemoveItemConstraints(NameFormat.parse(itemName, this.nsResolver));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropDef[] pda = this.ntd.getPropertyDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i].getId());
        }
        return propDefs;
    }
}

