/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventFilter {
    private static final Logger log = LoggerFactory.getLogger((Class)EventFilter.class);
    static final EventFilter BLOCK_ALL = new BlockAllFilter();
    private final ItemManager itemMgr;
    private final SessionImpl session;
    private final long eventTypes;
    private final Path path;
    private final boolean isDeep;
    private final NodeId[] ids;
    private final NodeTypeImpl[] nodeTypes;
    private final boolean noLocal;

    EventFilter(ItemManager itemMgr, SessionImpl session, long eventTypes, Path path, boolean isDeep, NodeId[] ids, NodeTypeImpl[] nodeTypes, boolean noLocal) {
        this.itemMgr = itemMgr;
        this.session = session;
        this.eventTypes = eventTypes;
        this.path = path;
        this.isDeep = isDeep;
        this.ids = ids;
        this.noLocal = noLocal;
        this.nodeTypes = nodeTypes;
    }

    SessionImpl getSession() {
        return this.session;
    }

    ItemManager getItemManager() {
        return this.itemMgr;
    }

    boolean blocks(EventState eventState) throws RepositoryException {
        int i;
        boolean match;
        long type = eventState.getType();
        if ((this.eventTypes & type) == 0L) {
            return true;
        }
        if (this.noLocal && this.session.equals(eventState.getSession())) {
            return true;
        }
        NodeId parentId = eventState.getParentId();
        if (this.ids != null) {
            match = false;
            for (i = 0; i < this.ids.length && !match; match |= parentId.equals(this.ids[i]), ++i) {
            }
            if (!match) {
                return true;
            }
        }
        if (this.nodeTypes != null) {
            match = false;
            for (i = 0; i < this.nodeTypes.length && !match; match |= eventState.getNodeType().getQName().equals(this.nodeTypes[i].getQName()) || eventState.getMixinNames().contains(this.nodeTypes[i].getQName()) || eventState.getNodeType().isDerivedFrom(this.nodeTypes[i].getQName()), ++i) {
            }
            if (!match) {
                return true;
            }
        }
        try {
            Path.PathElement nameElem;
            Path eventPath = null;
            eventPath = type == 1L || type == 2L ? ((nameElem = eventState.getChildRelPath()).getIndex() == 0 ? Path.create(eventState.getParentPath(), nameElem.getName(), false) : Path.create(eventState.getParentPath(), nameElem.getName(), nameElem.getIndex(), false)) : eventState.getParentPath();
            boolean match2 = eventPath.equals(this.path);
            if (!match2 && this.isDeep) {
                match2 = eventPath.isDescendantOf(this.path);
            }
            return !match2;
        }
        catch (MalformedPathException mpe) {
            throw new RepositoryException("internal error: failed to check path filter", (Throwable)mpe);
        }
    }

    private static final class BlockAllFilter
    extends EventFilter {
        BlockAllFilter() {
            super(null, null, 0L, null, true, null, null, true);
        }

        boolean blocks(EventState eventState) {
            return true;
        }
    }
}

