/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.Reader;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIndexer {
    private static final Logger log = LoggerFactory.getLogger((Class)NodeIndexer.class);
    protected final NodeState node;
    protected final ItemStateManager stateProvider;
    protected final NamespaceMappings mappings;
    protected final List textFilters;

    protected NodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, List textFilters) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.textFilters = textFilters;
    }

    public static Document createDocument(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, List textFilters) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, stateProvider, mappings, textFilters);
        return indexer.createDoc();
    }

    protected Document createDoc() throws RepositoryException {
        Document doc = new Document();
        doc.add(new Field(FieldNames.UUID, this.node.getNodeId().getUUID().toString(), true, true, false));
        try {
            if (this.node.getParentId() == null) {
                doc.add(new Field(FieldNames.PARENT, "", true, true, false));
                doc.add(new Field(FieldNames.LABEL, "", false, true, false));
            } else {
                doc.add(new Field(FieldNames.PARENT, this.node.getParentId().toString(), true, true, false));
                NodeState parent = (NodeState)this.stateProvider.getItemState(this.node.getParentId());
                NodeState.ChildNodeEntry child = parent.getChildNodeEntry(this.node.getNodeId());
                String name = NameFormat.format(child.getName(), (NamespaceResolver)this.mappings);
                doc.add(new Field(FieldNames.LABEL, name, false, true, false));
            }
        }
        catch (NoSuchItemStateException e) {
            this.throwRepositoryException(e);
        }
        catch (ItemStateException e) {
            this.throwRepositoryException(e);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        Set props = this.node.getPropertyNames();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            QName propName = (QName)it.next();
            PropertyId id = new PropertyId(this.node.getNodeId(), propName);
            try {
                PropertyState propState = (PropertyState)this.stateProvider.getItemState(id);
                InternalValue[] values = propState.getValues();
                for (int i = 0; i < values.length; ++i) {
                    this.addValue(doc, values[i], propState.getName());
                }
                if (values.length <= 1) continue;
                this.addMVPName(doc, propState.getName());
            }
            catch (NoSuchItemStateException e) {
                this.throwRepositoryException(e);
            }
            catch (ItemStateException e) {
                this.throwRepositoryException(e);
            }
        }
        return doc;
    }

    private void throwRepositoryException(Exception e) throws RepositoryException {
        String msg = "Error while indexing node: " + this.node.getNodeId() + " of " + "type: " + this.node.getNodeTypeName();
        throw new RepositoryException(msg, (Throwable)e);
    }

    private void addMVPName(Document doc, QName name) {
        try {
            String propName = NameFormat.format(name, (NamespaceResolver)this.mappings);
            doc.add(new Field(FieldNames.MVP, propName, false, true, false));
        }
        catch (NoPrefixDeclaredException noPrefixDeclaredException) {
            // empty catch block
        }
    }

    private void addValue(Document doc, InternalValue value, QName name) {
        String fieldName = name.getLocalName();
        try {
            fieldName = NameFormat.format(name, (NamespaceResolver)this.mappings);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        Object internalValue = value.internalValue();
        switch (value.getType()) {
            case 2: {
                this.addBinaryValue(doc, fieldName, internalValue);
                break;
            }
            case 6: {
                this.addBooleanValue(doc, fieldName, internalValue);
                break;
            }
            case 5: {
                this.addCalendarValue(doc, fieldName, internalValue);
                break;
            }
            case 4: {
                this.addDoubleValue(doc, fieldName, internalValue);
                break;
            }
            case 3: {
                this.addLongValue(doc, fieldName, internalValue);
                break;
            }
            case 9: {
                this.addReferenceValue(doc, fieldName, internalValue);
                break;
            }
            case 8: {
                this.addPathValue(doc, fieldName, internalValue);
                break;
            }
            case 1: {
                this.addStringValue(doc, fieldName, internalValue);
                break;
            }
            case 7: {
                this.addNameValue(doc, fieldName, internalValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type");
            }
        }
    }

    protected void addBinaryValue(Document doc, String fieldName, Object internalValue) {
        try {
            String jcrData = this.mappings.getPrefix("http://www.jcp.org/jcr/1.0") + ":data";
            if (!jcrData.equals(fieldName)) {
                return;
            }
            if (this.node.hasPropertyName(QName.JCR_MIMETYPE)) {
                PropertyState dataProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_DATA));
                PropertyState mimeTypeProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_MIMETYPE));
                String encoding = null;
                if (this.node.hasPropertyName(QName.JCR_ENCODING)) {
                    PropertyState encodingProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_ENCODING));
                    encoding = encodingProp.getValues()[0].internalValue().toString();
                }
                String mimeType = mimeTypeProp.getValues()[0].internalValue().toString();
                Map fields = Collections.EMPTY_MAP;
                Iterator<Object> it = this.textFilters.iterator();
                while (it.hasNext()) {
                    TextFilter filter = (TextFilter)it.next();
                    if (!filter.canFilter(mimeType)) continue;
                    fields = filter.doFilter(dataProp, encoding);
                    break;
                }
                it = fields.keySet().iterator();
                while (it.hasNext()) {
                    String field = (String)it.next();
                    Reader r = (Reader)fields.get(field);
                    doc.add(Field.Text((String)field, (Reader)r));
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception while indexing binary property: " + e.toString());
            log.debug("Dump: ", (Throwable)e);
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue.toString()), false, true, false));
    }

    protected void addCalendarValue(Document doc, String fieldName, Object internalValue) {
        long millis = ((Calendar)internalValue).getTimeInMillis();
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, DateField.timeToString(millis)), false, true, false));
    }

    protected void addDoubleValue(Document doc, String fieldName, Object internalValue) {
        double doubleVal = (Double)internalValue;
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, DoubleField.doubleToString(doubleVal)), false, true, false));
    }

    protected void addLongValue(Document doc, String fieldName, Object internalValue) {
        long longVal = (Long)internalValue;
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, LongField.longToString(longVal)), false, true, false));
    }

    protected void addReferenceValue(Document doc, String fieldName, Object internalValue) {
        String uuid = internalValue.toString();
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, uuid), true, true, false));
    }

    protected void addPathValue(Document doc, String fieldName, Object internalValue) {
        Path path = (Path)internalValue;
        String pathString = path.toString();
        try {
            pathString = PathFormat.format(path, this.mappings);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, pathString), false, true, false));
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue) {
        String stringValue = String.valueOf(internalValue);
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, stringValue), false, true, false));
        doc.add(new Field(FieldNames.FULLTEXT, stringValue, false, true, true));
        int idx = fieldName.indexOf(58);
        fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
        doc.add(new Field(fieldName, stringValue, false, true, true));
    }

    protected void addNameValue(Document doc, String fieldName, Object internalValue) {
        QName qualiName = (QName)internalValue;
        String normValue = internalValue.toString();
        try {
            normValue = this.mappings.getPrefix(qualiName.getNamespaceURI()) + ":" + qualiName.getLocalName();
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, normValue), false, true, false));
    }
}

