/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.LRUItemStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLRUItemStateCache
implements ItemStateCache {
    private static Logger log = LoggerFactory.getLogger((Class)LRUItemStateCache.class);
    public static final int DEFAULT_MAX_MEM = 0x400000;
    private long totalMem;
    private final long maxMem;
    private long numWrites = 0L;
    private final LinkedMap cache = new LinkedMap();

    public MLRUItemStateCache() {
        this(0x400000);
    }

    public MLRUItemStateCache(int maxMem) {
        this.maxMem = maxMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(ItemId id) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.containsKey((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState retrieve(ItemId id) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.remove((Object)id);
            if (entry != null) {
                this.cache.put((Object)id, (Object)entry);
                return entry.state;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ItemId id) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.get((Object)id);
            if (entry != null) {
                this.totalMem -= entry.size;
                entry.recalc();
                this.totalMem += entry.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(ItemState state) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            ItemId id = state.getId();
            if (this.cache.containsKey((Object)id)) {
                log.warn("overwriting cached entry " + id);
                this.evict(id);
            }
            Entry entry = new Entry(state);
            this.cache.put((Object)id, (Object)entry);
            this.totalMem += entry.size;
            while (this.totalMem > this.maxMem) {
                id = (ItemId)this.cache.firstKey();
                this.evict(id);
            }
            if (this.numWrites++ % 10000L == 0L && log.isDebugEnabled()) {
                log.info(this + " size=" + this.cache.size() + ", " + this.totalMem + "/" + this.maxMem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(ItemId id) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.remove((Object)id);
            if (entry != null) {
                this.totalMem -= entry.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            this.cache.clear();
            this.totalMem = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return Collections.unmodifiableSet(this.cache.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            ArrayList<ItemState> list = new ArrayList<ItemState>(this.cache.size());
            Iterator iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                list.add(entry.state);
            }
            return list;
        }
    }

    private static class Entry {
        private final ItemState state;
        private long size;

        public Entry(ItemState state) {
            this.state = state;
            this.size = 64L + state.calculateMemoryFootprint();
        }

        public void recalc() {
            this.size = 64L + this.state.calculateMemoryFootprint();
        }
    }
}

