/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Iterator;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAItemStateManager
extends LocalItemStateManager
implements InternalXAResource {
    private static Logger log = LoggerFactory.getLogger((Class)XAItemStateManager.class);
    private static final String DEFAULT_ATTRIBUTE_NAME = "ChangeLog";
    private ThreadLocal commitLog = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new CommitLog();
        }
    };
    private transient ChangeLog txLog;
    private transient SharedItemStateManager.Update update;
    private final String attributeName;
    private VirtualItemStateProvider virtualProvider;

    public XAItemStateManager(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory) {
        this(sharedStateMgr, factory, DEFAULT_ATTRIBUTE_NAME);
    }

    public XAItemStateManager(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory, String attributeName) {
        super(sharedStateMgr, factory);
        this.attributeName = attributeName;
    }

    public void setVirtualProvider(VirtualItemStateProvider virtualProvider) {
        this.virtualProvider = virtualProvider;
    }

    public void associate(TransactionContext tx) {
        ChangeLog txLog = null;
        if (tx != null && (txLog = (ChangeLog)tx.getAttribute(this.attributeName)) == null) {
            txLog = new ChangeLog();
            tx.setAttribute(this.attributeName, txLog);
        }
        this.txLog = txLog;
    }

    public void beforeOperation(TransactionContext tx) {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null) {
            ((CommitLog)this.commitLog.get()).setChanges(txLog);
        }
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null) {
            try {
                if (this.virtualProvider != null) {
                    this.updateVirtualReferences(txLog);
                }
                this.update = this.sharedStateMgr.beginUpdate(txLog, this.factory, this.virtualProvider);
            }
            catch (ReferentialIntegrityException rie) {
                log.error(rie.getMessage(), (Throwable)rie);
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to prepare transaction.", rie);
            }
            catch (ItemStateException ise) {
                log.error(ise.getMessage(), (Throwable)ise);
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to prepare transaction.", ise);
            }
        }
    }

    public void commit(TransactionContext tx) throws TransactionException {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null) {
            try {
                this.update.end();
            }
            catch (ItemStateException ise) {
                log.error(ise.getMessage(), (Throwable)ise);
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to commit transaction.", ise);
            }
            txLog.reset();
        }
    }

    public void rollback(TransactionContext tx) {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null) {
            if (this.update != null) {
                this.update.cancel();
            }
            txLog.undo(this.sharedStateMgr);
        }
    }

    public void afterOperation(TransactionContext tx) {
        ((CommitLog)this.commitLog.get()).setChanges(null);
    }

    public ChangeLog getChangeLog() {
        ChangeLog changeLog = ((CommitLog)this.commitLog.get()).getChanges();
        if (changeLog == null) {
            changeLog = this.txLog;
        }
        return changeLog;
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state;
        if (this.virtualProvider != null && this.virtualProvider.hasItemState(id)) {
            return this.virtualProvider.getItemState(id);
        }
        ChangeLog changeLog = this.getChangeLog();
        if (changeLog != null && (state = changeLog.get(id)) != null) {
            return state;
        }
        return super.getItemState(id);
    }

    public boolean hasItemState(ItemId id) {
        if (this.virtualProvider != null && this.virtualProvider.hasItemState(id)) {
            return true;
        }
        ChangeLog changeLog = this.getChangeLog();
        if (changeLog != null) {
            try {
                ItemState state = changeLog.get(id);
                if (state != null) {
                    return true;
                }
            }
            catch (NoSuchItemStateException e) {
                return false;
            }
        }
        return super.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs;
        if (this.virtualProvider != null && this.virtualProvider.hasNodeReferences(id)) {
            return this.virtualProvider.getNodeReferences(id);
        }
        ChangeLog changeLog = this.getChangeLog();
        if (changeLog != null && (refs = changeLog.get(id)) != null) {
            return refs;
        }
        return super.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        if (this.virtualProvider != null && this.virtualProvider.hasNodeReferences(id)) {
            return true;
        }
        ChangeLog changeLog = this.getChangeLog();
        if (changeLog != null && changeLog.get(id) != null) {
            return true;
        }
        return super.hasNodeReferences(id);
    }

    protected void update(ChangeLog changeLog) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        if (this.txLog != null) {
            this.txLog.merge(changeLog);
        } else {
            super.update(changeLog);
        }
    }

    private void updateVirtualReferences(ChangeLog changes) throws ItemStateException {
        NodeReferencesId refsId;
        InternalValue[] vals;
        PropertyState prop;
        ItemState state;
        Iterator iter = changes.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                UUID uuid = (UUID)vals[i].internalValue();
                refsId = new NodeReferencesId(uuid);
                this.addVirtualReference(prop.getPropertyId(), refsId);
            }
        }
        iter = changes.modifiedStates();
        while (iter.hasNext()) {
            NodeReferencesId refsId2;
            UUID uuid;
            int i;
            InternalValue[] vals2;
            state = (ItemState)iter.next();
            if (state.isNode()) continue;
            PropertyState newProp = (PropertyState)state;
            PropertyState oldProp = (PropertyState)this.getItemState(state.getId());
            if (oldProp.getType() == 9) {
                vals2 = oldProp.getValues();
                for (i = 0; vals2 != null && i < vals2.length; ++i) {
                    uuid = (UUID)vals2[i].internalValue();
                    refsId2 = new NodeReferencesId(uuid);
                    this.removeVirtualReference(oldProp.getPropertyId(), refsId2);
                }
            }
            if (newProp.getType() != 9) continue;
            vals2 = newProp.getValues();
            for (i = 0; vals2 != null && i < vals2.length; ++i) {
                uuid = (UUID)vals2[i].internalValue();
                refsId2 = new NodeReferencesId(uuid);
                this.addVirtualReference(newProp.getPropertyId(), refsId2);
            }
        }
        iter = changes.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                UUID uuid = (UUID)vals[i].internalValue();
                refsId = new NodeReferencesId(uuid);
                this.removeVirtualReference(prop.getPropertyId(), refsId);
            }
        }
    }

    private void addVirtualReference(PropertyId sourceId, NodeReferencesId refsId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = this.virtualProvider.getNodeReferences(refsId);
        if (refs == null && this.virtualProvider.hasItemState(refsId.getTargetId())) {
            refs = new NodeReferences(refsId);
        }
        if (refs != null) {
            refs.addReference(sourceId);
            this.virtualProvider.setNodeReferences(refs);
        }
    }

    private void removeVirtualReference(PropertyId sourceId, NodeReferencesId refsId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = this.virtualProvider.getNodeReferences(refsId);
        if (refs == null && this.virtualProvider.hasItemState(refsId.getTargetId())) {
            refs = new NodeReferences(refsId);
        }
        if (refs != null) {
            refs.removeReference(sourceId);
            this.virtualProvider.setNodeReferences(refs);
        }
    }

    private static class CommitLog {
        private ChangeLog changes;

        private CommitLog() {
        }

        private void setChanges(ChangeLog changes) {
            this.changes = changes;
        }

        private ChangeLog getChanges() {
            return this.changes;
        }
    }
}

