/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.state.db.SimpleDbPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyPersistenceManager
extends SimpleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger((Class)DerbyPersistenceManager.class);

    public DerbyPersistenceManager() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
    }

    protected void closeConnection(Connection connection) throws SQLException {
        String url = connection.getMetaData().getURL();
        int pos = url.lastIndexOf(59);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        url = url + ";shutdown=true";
        connection.setAutoCommit(true);
        try {
            DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            log.info(e.getMessage());
        }
    }
}

