/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;

class StringValue
implements TextValue {
    private final String value;
    private final NamespaceResolver nsContext;

    protected StringValue(String value, NamespaceResolver nsContext) {
        this.value = value;
        this.nsContext = nsContext;
    }

    public Value getValue(int type, NamespaceResolver resolver) throws ValueFormatException, RepositoryException {
        if (type == 7 || type == 8) {
            InternalValue ival = InternalValue.create(ValueHelper.convert(this.value, type, ValueFactoryImpl.getInstance()), this.nsContext);
            return ival.toJCRValue(resolver);
        }
        if (type == 2) {
            return ValueHelper.deserialize(this.value, type, false, ValueFactoryImpl.getInstance());
        }
        return ValueHelper.deserialize(this.value, type, true, ValueFactoryImpl.getInstance());
    }

    public InternalValue getInternalValue(int targetType) throws ValueFormatException, RepositoryException {
        try {
            if (targetType == 2) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64.decode(this.value, (OutputStream)baos);
                return InternalValue.create(baos.toByteArray());
            }
            return InternalValue.create(ValueHelper.convert(this.value, targetType, ValueFactoryImpl.getInstance()), this.nsContext);
        }
        catch (IOException e) {
            throw new RepositoryException("Error decoding Base64 content", (Throwable)e);
        }
    }

    public void dispose() {
    }
}

