/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger((Class)WorkspaceImporter.class);
    private final NodeState importTarget;
    private final WorkspaceImpl wsp;
    private final NodeTypeRegistry ntReg;
    private final HierarchyManager hierMgr;
    private final BatchedItemOperations itemOps;
    private final int uuidBehavior;
    private boolean aborted;
    private Stack parents;
    private final ReferenceChangeTracker refTracker;

    public WorkspaceImporter(Path parentPath, WorkspaceImpl wsp, NodeTypeRegistry ntReg, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        SessionImpl ses = (SessionImpl)wsp.getSession();
        this.itemOps = new BatchedItemOperations(wsp.getItemStateManager(), ntReg, ses.getLockManager(), ses, wsp.getHierarchyManager(), ses.getNamespaceResolver());
        this.hierMgr = wsp.getHierarchyManager();
        this.itemOps.verifyCanWrite(parentPath);
        this.importTarget = this.itemOps.getNodeState(parentPath);
        this.wsp = wsp;
        this.ntReg = ntReg;
        this.uuidBehavior = uuidBehavior;
        this.aborted = false;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(this.importTarget);
    }

    protected NodeState resolveUUIDConflict(NodeState parent, NodeState conflicting, NodeInfo nodeInfo) throws RepositoryException {
        NodeState node;
        if (this.uuidBehavior == 0) {
            this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
            node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
            if (ent.includesNodeType(QName.MIX_REFERENCEABLE)) {
                this.refTracker.mappedUUID(nodeInfo.getId().getUUID(), node.getNodeId().getUUID());
            }
        } else {
            if (this.uuidBehavior == 3) {
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                Path p0 = this.hierMgr.getPath(this.importTarget.getNodeId());
                Path p1 = this.hierMgr.getPath(conflicting.getNodeId());
                try {
                    if (p1.equals(p0) || p1.isAncestorOf(p0)) {
                        String msg = "cannot remove ancestor node";
                        log.debug(msg);
                        throw new ConstraintViolationException(msg);
                    }
                }
                catch (MalformedPathException mpe) {
                    String msg = "internal error: failed to determine degree of relationship";
                    log.error(msg, (Throwable)mpe);
                    throw new RepositoryException(msg, (Throwable)mpe);
                }
                this.itemOps.checkRemoveNode(conflicting, 23);
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                NodeId parentId = conflicting.getParentId();
                if (parentId == null) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                try {
                    parent = this.itemOps.getNodeState(parentId);
                }
                catch (ItemNotFoundException infe) {
                    String msg = "internal error: failed to retrieve parent state";
                    log.error(msg, (Throwable)infe);
                    throw new RepositoryException(msg, (Throwable)infe);
                }
                this.itemOps.checkRemoveNode(conflicting, 23);
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 23);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return node;
    }

    protected void postProcessNode(NodeState node) throws RepositoryException {
        EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
        if (ent.includesNodeType(QName.MIX_VERSIONABLE)) {
            PropertyState prop;
            PropDef def;
            SessionImpl session = (SessionImpl)this.wsp.getSession();
            VersionManager vMgr = session.getVersionManager();
            VersionHistory vh = vMgr.getVersionHistory(session, node);
            if (vh == null) {
                vh = vMgr.createVersionHistory(session, node);
            }
            if (!node.hasPropertyName(QName.JCR_VERSIONHISTORY)) {
                def = this.itemOps.findApplicablePropertyDefinition(QName.JCR_VERSIONHISTORY, 9, false, node);
                prop = this.itemOps.createPropertyState(node, QName.JCR_VERSIONHISTORY, 9, def);
                prop.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getUUID()))});
            }
            if (!node.hasPropertyName(QName.JCR_BASEVERSION)) {
                def = this.itemOps.findApplicablePropertyDefinition(QName.JCR_BASEVERSION, 9, false, node);
                prop = this.itemOps.createPropertyState(node, QName.JCR_BASEVERSION, 9, def);
                prop.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getRootVersion().getUUID()))});
            }
            if (!node.hasPropertyName(QName.JCR_PREDECESSORS)) {
                def = this.itemOps.findApplicablePropertyDefinition(QName.JCR_PREDECESSORS, 9, true, node);
                prop = this.itemOps.createPropertyState(node, QName.JCR_PREDECESSORS, 9, def);
                prop.setValues(new InternalValue[]{InternalValue.create(new UUID(vh.getRootVersion().getUUID()))});
            }
            if (!node.hasPropertyName(QName.JCR_ISCHECKEDOUT)) {
                def = this.itemOps.findApplicablePropertyDefinition(QName.JCR_ISCHECKEDOUT, 6, false, node);
                prop = this.itemOps.createPropertyState(node, QName.JCR_ISCHECKEDOUT, 6, def);
                prop.setValues(new InternalValue[]{InternalValue.create(true)});
            }
        }
    }

    public void start() throws RepositoryException {
        try {
            this.itemOps.edit();
        }
        catch (IllegalStateException ise) {
            this.aborted = true;
            String msg = "internal error: failed to start update operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNode(NodeInfo nodeInfo, List propInfos) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        boolean succeeded = false;
        try {
            NodeState.ChildNodeEntry entry;
            NodeId idExisting;
            NodeState existing;
            NodeDef def;
            this.wsp.sanityCheck();
            NodeState parent = (NodeState)this.parents.peek();
            NodeState node = null;
            NodeId id = nodeInfo.getId();
            QName nodeName = nodeInfo.getName();
            QName ntName = nodeInfo.getNodeTypeName();
            QName[] mixins = nodeInfo.getMixinNames();
            if (parent == null) {
                this.parents.push(null);
                succeeded = true;
                log.debug("skipping node " + nodeName);
                return;
            }
            if (parent.hasChildNodeEntry(nodeName) && !(def = this.ntReg.getNodeDef((existing = (NodeState)this.itemOps.getItemState(idExisting = (entry = parent.getChildNodeEntry(nodeName, 1)).getId())).getDefinitionId())).allowsSameNameSiblings()) {
                EffectiveNodeType entExisting = this.itemOps.getEffectiveNodeType(existing);
                if (def.isProtected() && entExisting.includesNodeType(ntName)) {
                    this.parents.push(null);
                    succeeded = true;
                    log.debug("skipping protected node " + this.itemOps.safeGetJCRPath(existing.getNodeId()));
                    return;
                }
                if (def.isAutoCreated() && entExisting.includesNodeType(ntName)) {
                    node = existing;
                } else {
                    throw new ItemExistsException(this.itemOps.safeGetJCRPath(existing.getNodeId()));
                }
            }
            if (node == null) {
                if (id == null) {
                    PropertyId propId;
                    PropertyState conflicting;
                    NodeDef def2 = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                    if (def2.isProtected()) {
                        this.parents.push(null);
                        succeeded = true;
                        log.debug("skipping protected node " + nodeName);
                        return;
                    }
                    if (parent.hasPropertyName(nodeName) && (conflicting = this.itemOps.getPropertyState(propId = new PropertyId(parent.getNodeId(), nodeName))).getStatus() == 4) {
                        QName newName = new QName(nodeName.getNamespaceURI(), nodeName.getLocalName() + "_");
                        if (parent.hasPropertyName(newName)) {
                            newName = new QName(newName.getNamespaceURI(), newName.getLocalName() + "_");
                        }
                        PropertyState newProp = this.itemOps.createPropertyState(parent, newName, conflicting.getType(), conflicting.getValues().length);
                        newProp.setValues(conflicting.getValues());
                        parent.removePropertyName(nodeName);
                        this.itemOps.store(parent);
                        this.itemOps.destroy(conflicting);
                    }
                    this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                    node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, null, def2);
                } else {
                    NodeState conflicting;
                    try {
                        conflicting = this.itemOps.getNodeState(id);
                    }
                    catch (ItemNotFoundException infe) {
                        conflicting = null;
                    }
                    if (conflicting != null) {
                        node = this.resolveUUIDConflict(parent, conflicting, nodeInfo);
                    } else {
                        NodeDef def3 = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                        if (def3.isProtected()) {
                            this.parents.push(null);
                            succeeded = true;
                            log.debug("skipping protected node " + nodeName);
                            return;
                        }
                        this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                        node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, id, def3);
                    }
                }
            }
            Iterator iter = propInfos.iterator();
            while (iter.hasNext()) {
                PropInfo pi = (PropInfo)iter.next();
                pi.apply(node, this.itemOps, this.ntReg, this.refTracker);
            }
            this.itemOps.store(node);
            this.itemOps.store(parent);
            this.parents.push(node);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        NodeState node = (NodeState)this.parents.pop();
        if (node == null) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            this.postProcessNode(node);
            this.itemOps.validate(node);
            this.itemOps.store(node);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws RepositoryException {
        if (this.aborted) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            Iterator iter = this.refTracker.getProcessedReferences();
            while (iter.hasNext()) {
                PropertyState prop = (PropertyState)iter.next();
                if (prop.getType() != 9) continue;
                boolean modified = false;
                InternalValue[] values = prop.getValues();
                InternalValue[] newVals = new InternalValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    InternalValue val = values[i];
                    UUID original = (UUID)val.internalValue();
                    UUID adjusted = this.refTracker.getMappedUUID(original);
                    if (adjusted != null) {
                        newVals[i] = InternalValue.create(adjusted);
                        modified = true;
                        continue;
                    }
                    newVals[i] = val;
                }
                if (!modified) continue;
                prop.setValues(newVals);
                this.itemOps.store(prop);
            }
            this.refTracker.clear();
            this.itemOps.validate(this.importTarget);
            this.itemOps.store(this.importTarget);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
        if (!this.aborted) {
            this.itemOps.update();
        }
    }
}

