/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.apache.jackrabbit.core.security.authentication.ImpersonationCallback;
import org.apache.jackrabbit.core.security.authentication.RepositoryCallback;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandlerImpl
implements CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandlerImpl.class);
    private final Session session;
    private final Credentials credentials;
    private final PrincipalProviderRegistry principalProviderRegistry;
    private final String adminId;
    private final String anonymousId;

    public CallbackHandlerImpl(Credentials credentials, Session session, PrincipalProviderRegistry principalProviderRegistry, String adminId, String anonymousId) {
        this.credentials = credentials;
        this.session = session;
        this.principalProviderRegistry = principalProviderRegistry;
        this.adminId = adminId;
        this.anonymousId = anonymousId;
        if (session == null) {
            log.debug("Session is null -> CallbackHandler won't be able to handle RepositoryCallback.");
        }
        if (principalProviderRegistry == null) {
            log.debug("PrincipalProviderRegistry is null -> CallbackHandler won't be able to handle RepositoryCallback.");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CredentialsCallback) {
                ((CredentialsCallback)callback).setCredentials(this.credentials);
                continue;
            }
            if (callback instanceof RepositoryCallback) {
                if (this.session == null || this.principalProviderRegistry == null) {
                    throw new UnsupportedCallbackException(callback);
                }
                RepositoryCallback rcb = (RepositoryCallback)callback;
                rcb.setSession(this.session);
                rcb.setPrincipalProviderRegistry(this.principalProviderRegistry);
                rcb.setAdminId(this.adminId);
                rcb.setAnonymousId(this.anonymousId);
                continue;
            }
            if (this.credentials != null && this.credentials instanceof SimpleCredentials) {
                SimpleCredentials simpleCreds = (SimpleCredentials)this.credentials;
                if (callback instanceof NameCallback) {
                    String userId = simpleCreds.getUserID();
                    ((NameCallback)callback).setName(userId);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    char[] pw = simpleCreds.getPassword();
                    ((PasswordCallback)callback).setPassword(pw);
                    continue;
                }
                if (callback instanceof ImpersonationCallback) {
                    Object impersAttr = simpleCreds.getAttribute("org.apache.jackrabbit.core.security.impersonator");
                    ((ImpersonationCallback)callback).setImpersonator(impersAttr);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

