/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.DefaultSecurityManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.DefaultPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.security.user.UserPerWorkspaceUserManager;

public class UserPerWorkspaceSecurityManager
extends DefaultSecurityManager {
    private final Map<String, PrincipalProviderRegistry> ppRegistries = new HashMap<String, PrincipalProviderRegistry>();
    private final List<String> systemUsersInitialized = new ArrayList<String>();

    private PrincipalProviderRegistry getPrincipalProviderRegistry(SessionImpl s) throws RepositoryException {
        String wspName = s.getWorkspace().getName();
        PrincipalProviderRegistry p = this.ppRegistries.get(wspName);
        if (p == null) {
            SystemSession systemSession;
            if (s instanceof SystemSession) {
                systemSession = (SystemSession)s;
            } else {
                RepositoryImpl repo = (RepositoryImpl)this.getRepository();
                systemSession = repo.getSystemSession(wspName);
                repo.onSessionCreated(systemSession);
            }
            DefaultPrincipalProvider defaultPP = new DefaultPrincipalProvider((Session)systemSession, (UserManagerImpl)this.getUserManager((Session)systemSession));
            defaultPP.init(new Properties());
            p = new WorkspaceBasedPrincipalProviderRegistry(defaultPP);
            this.ppRegistries.put(wspName, p);
        }
        return p;
    }

    public void init(Repository repository, Session systemSession) throws RepositoryException {
        super.init(repository, systemSession);
        this.systemUsersInitialized.add(systemSession.getWorkspace().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String workspaceName) {
        super.dispose(workspaceName);
        Map<String, PrincipalProviderRegistry> map = this.ppRegistries;
        synchronized (map) {
            PrincipalProviderRegistry reg = this.ppRegistries.remove(workspaceName);
            if (reg != null) {
                reg.getDefault().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        Map<String, PrincipalProviderRegistry> map = this.ppRegistries;
        synchronized (map) {
            for (PrincipalProviderRegistry registry : this.ppRegistries.values()) {
                registry.getDefault().close();
            }
            this.ppRegistries.clear();
        }
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session == this.getSystemSession()) {
            return super.getUserManager(session);
        }
        if (session instanceof SessionImpl) {
            UserManagerImpl uMgr = this.createUserManager((SessionImpl)session);
            String wspName = session.getWorkspace().getName();
            if (session instanceof SystemSession && !this.systemUsersInitialized.contains(wspName)) {
                UserPerWorkspaceSecurityManager.createSystemUsers(uMgr, (SystemSession)session, this.adminId, this.anonymousId);
                this.systemUsersInitialized.add(wspName);
            }
            return uMgr;
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    public AuthContext getAuthContext(Credentials creds, Subject subject, String workspaceName) throws RepositoryException {
        this.checkInitialized();
        SystemSession systemSession = ((RepositoryImpl)this.getRepository()).getSystemSession(workspaceName);
        return this.getAuthContextProvider().getAuthContext(creds, subject, (Session)systemSession, this.getPrincipalProviderRegistry(systemSession), this.adminId, this.anonymousId);
    }

    protected PrincipalProvider createDefaultPrincipalProvider() throws RepositoryException {
        return null;
    }

    protected UserManager getSystemUserManager(String workspaceName) throws RepositoryException {
        if (workspaceName.equals(this.getSystemSession().getWorkspace().getName())) {
            return super.getSystemUserManager(workspaceName);
        }
        return ((RepositoryImpl)this.getRepository()).getWorkspaceInfo(workspaceName).getSystemSession().getUserManager();
    }

    protected UserManagerImpl createUserManager(SessionImpl session) throws RepositoryException {
        Properties params;
        UserManagerConfig umc = this.getConfig().getUserManagerConfig();
        Properties properties = params = umc == null ? null : umc.getParameters();
        if (umc != null) {
            Class[] paramTypes = new Class[]{SessionImpl.class, String.class, Properties.class};
            return (UserPerWorkspaceUserManager)umc.getUserManager(UserPerWorkspaceUserManager.class, paramTypes, session, this.adminId, params);
        }
        return new UserPerWorkspaceUserManager(session, this.adminId, params);
    }

    protected PrincipalManager createPrincipalManager(SessionImpl session) throws RepositoryException {
        return new PrincipalManagerImpl((Session)session, this.getPrincipalProviderRegistry(session).getProviders());
    }

    protected WorkspaceAccessManager createDefaultWorkspaceAccessManager() {
        return new WorkspaceAccessManagerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WorkspaceAccessManagerImpl
    implements WorkspaceAccessManager {
        private WorkspaceAccessManagerImpl() {
        }

        @Override
        public void init(Session systemSession) throws RepositoryException {
        }

        @Override
        public void close() throws RepositoryException {
        }

        @Override
        public boolean grants(Set<Principal> principals, String workspaceName) throws RepositoryException {
            if (!Arrays.asList(((RepositoryImpl)UserPerWorkspaceSecurityManager.this.getRepository()).getWorkspaceNames()).contains(workspaceName)) {
                return false;
            }
            UserManager umgr = UserPerWorkspaceSecurityManager.this.getSystemUserManager(workspaceName);
            for (Principal principal : principals) {
                if (principal instanceof Group || umgr.getAuthorizable(principal) == null) continue;
                return true;
            }
            return false;
        }
    }

    private final class WorkspaceBasedPrincipalProviderRegistry
    implements PrincipalProviderRegistry {
        private final PrincipalProvider defaultPrincipalProvider;

        public WorkspaceBasedPrincipalProviderRegistry(PrincipalProvider defaultPrincipalProvider) {
            this.defaultPrincipalProvider = defaultPrincipalProvider;
        }

        public PrincipalProvider registerProvider(Properties configuration) throws RepositoryException {
            return UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().registerProvider(configuration);
        }

        public PrincipalProvider getDefault() {
            return this.defaultPrincipalProvider;
        }

        public PrincipalProvider getProvider(String className) {
            PrincipalProvider p = UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().getProvider(className);
            if (p == null && this.defaultPrincipalProvider.getClass().getName().equals(className)) {
                p = this.defaultPrincipalProvider;
            }
            return p;
        }

        public PrincipalProvider[] getProviders() {
            ArrayList<PrincipalProvider> l = new ArrayList<PrincipalProvider>();
            l.addAll(Arrays.asList(UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().getProviders()));
            l.add(this.defaultPrincipalProvider);
            return l.toArray(new PrincipalProvider[l.size()]);
        }
    }
}

