/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.commons.NamespaceHelper;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeTypeManager;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.QDefinitionBuilderFactory;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeManagerImpl
extends AbstractNodeTypeManager
implements JackrabbitNodeTypeManager,
Dumpable,
NodeTypeRegistryListener {
    private final NodeTypeRegistry ntReg;
    private final SessionImpl session;
    private final ValueFactory valueFactory;
    private final NodeDefinitionImpl rootNodeDef;
    private final Map<Name, NodeTypeImpl> ntCache;
    private final Map<QPropertyDefinition, PropertyDefinitionImpl> pdCache;
    private final Map<QNodeDefinition, NodeDefinitionImpl> ndCache;
    private final DataStore store;
    private static final String APPLICATION_XML = "application/xml";

    public NodeTypeManagerImpl(NodeTypeRegistry ntReg, SessionImpl session, DataStore store) throws RepositoryException {
        this.ntReg = ntReg;
        this.session = session;
        this.valueFactory = session.getValueFactory();
        this.ntReg.addListener(this);
        this.store = store;
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
        this.rootNodeDef = new NodeDefinitionImpl((QItemDefinition)ntReg.getRootNodeDef(), (AbstractNodeTypeManager)this, (NamePathResolver)session);
        this.ndCache.put(this.rootNodeDef.unwrap(), this.rootNodeDef);
    }

    public NodeDefinitionImpl getRootNodeDefinition() {
        return this.rootNodeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDefinitionImpl getNodeDefinition(QNodeDefinition def) {
        Map<QNodeDefinition, NodeDefinitionImpl> map = this.ndCache;
        synchronized (map) {
            NodeDefinitionImpl ndi = this.ndCache.get(def);
            if (ndi == null) {
                ndi = new NodeDefinitionImpl((QItemDefinition)def, (AbstractNodeTypeManager)this, (NamePathResolver)this.session);
                this.ndCache.put(def, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinitionImpl getPropertyDefinition(QPropertyDefinition def) {
        Map<QPropertyDefinition, PropertyDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            PropertyDefinitionImpl pdi = this.pdCache.get(def);
            if (pdi == null) {
                pdi = new PropertyDefinitionImpl(def, (AbstractNodeTypeManager)this, (NamePathResolver)this.session, this.valueFactory);
                this.pdCache.put(def, pdi);
            }
            return pdi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeImpl getNodeType(Name name) throws NoSuchNodeTypeException {
        Map<Name, NodeTypeImpl> map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = this.ntCache.get(name);
            if (nt == null) {
                EffectiveNodeType ent = this.ntReg.getEffectiveNodeType(name);
                QNodeTypeDefinition def = this.ntReg.getNodeTypeDef(name);
                nt = new NodeTypeImpl(ent, def, this, this.session, this.valueFactory, this.store);
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    public NamePathResolver getNamePathResolver() {
        return this.session;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType, boolean reregisterExisting) throws IOException, RepositoryException {
        try {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            ArrayList<QNodeTypeDefinition> nodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
            if (contentType.equalsIgnoreCase("text/xml") || contentType.equalsIgnoreCase(APPLICATION_XML)) {
                try {
                    NodeTypeReader ntr = new NodeTypeReader(in);
                    Properties namespaces = ntr.getNamespaces();
                    if (namespaces != null) {
                        Enumeration<?> prefixes = namespaces.propertyNames();
                        while (prefixes.hasMoreElements()) {
                            String prefix = (String)prefixes.nextElement();
                            String uri = namespaces.getProperty(prefix);
                            namespaceMap.put(prefix, uri);
                        }
                    }
                    QNodeTypeDefinition[] defs = ntr.getNodeTypeDefs();
                    nodeTypeDefs.addAll(Arrays.asList(defs));
                }
                catch (NameException e) {
                    throw new RepositoryException("Illegal JCR name", (Throwable)e);
                }
            } else if (contentType.equalsIgnoreCase("text/x-jcr-cnd")) {
                try {
                    NamespaceMapping mapping = new NamespaceMapping((NamespaceResolver)this.session);
                    CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader((Reader)new InputStreamReader(in), "cnd input stream", (Object)mapping, (DefinitionBuilderFactory)new QDefinitionBuilderFactory());
                    namespaceMap.putAll(mapping.getPrefixToURIMapping());
                    for (QNodeTypeDefinition ntDef : reader.getNodeTypeDefinitions()) {
                        nodeTypeDefs.add(ntDef);
                    }
                }
                catch (ParseException e) {
                    IOException e2 = new IOException(e.getMessage());
                    e2.initCause(e);
                    throw e2;
                }
            } else {
                throw new UnsupportedRepositoryOperationException("Unsupported content type: " + contentType);
            }
            new NamespaceHelper((Session)this.session).registerNamespaces(namespaceMap);
            if (reregisterExisting) {
                ArrayList<QNodeTypeDefinition> newNodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
                ArrayList<QNodeTypeDefinition> registeredNodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
                for (QNodeTypeDefinition nodeTypeDef : nodeTypeDefs) {
                    if (this.ntReg.isRegistered(nodeTypeDef.getName())) {
                        registeredNodeTypeDefs.add(nodeTypeDef);
                        continue;
                    }
                    newNodeTypeDefs.add(nodeTypeDef);
                }
                ArrayList<NodeType> nodeTypes = new ArrayList<NodeType>();
                nodeTypes.addAll(this.registerNodeTypes(newNodeTypeDefs));
                for (QNodeTypeDefinition nodeTypeDef : registeredNodeTypeDefs) {
                    this.ntReg.reregisterNodeType(nodeTypeDef);
                    nodeTypes.add(this.getNodeType(nodeTypeDef.getName()));
                }
                return nodeTypes.toArray(new NodeType[nodeTypes.size()]);
            }
            Collection<NodeType> types = this.registerNodeTypes(nodeTypeDefs);
            return types.toArray(new NodeType[types.size()]);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Invalid node type definition", (Throwable)e);
        }
    }

    @Override
    public void nodeTypeRegistered(Name ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypeReRegistered(Name ntName) {
        Iterator<PropertyDefinitionImpl> iter;
        this.ntCache.remove(ntName);
        Map<QPropertyDefinition, PropertyDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = iter.next();
                if (!ntName.equals(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypeUnregistered(Name ntName) {
        Iterator<PropertyDefinitionImpl> iter;
        this.ntCache.remove(ntName);
        Map<QPropertyDefinition, PropertyDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = iter.next();
                if (!ntName.equals(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Object[] ntNames = this.ntReg.getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Object ntName : ntNames) {
            list.add(this.getNodeType((Name)ntName));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Object[] ntNames = this.ntReg.getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Object ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType((Name)ntName);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Object[] ntNames = this.ntReg.getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Object ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType((Name)ntName);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            return this.getNodeType(this.session.getQName(nodeTypeName));
        }
        catch (NameException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
        catch (NamespaceException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
    }

    private Collection<NodeType> registerNodeTypes(List<QNodeTypeDefinition> defs) throws InvalidNodeTypeDefException, RepositoryException {
        this.ntReg.registerNodeTypes(defs);
        HashSet<NodeType> types = new HashSet<NodeType>();
        for (QNodeTypeDefinition def : defs) {
            try {
                types.add(this.getNodeType(def.getName()));
            }
            catch (NoSuchNodeTypeException e) {}
        }
        return types;
    }

    public NodeType[] registerNodeTypes(InputSource in) throws SAXException, RepositoryException {
        try {
            return this.registerNodeTypes(in.getByteStream(), "text/xml");
        }
        catch (IOException e) {
            throw new SAXException("Error reading node type stream", e);
        }
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType) throws IOException, RepositoryException {
        return this.registerNodeTypes(in, contentType, false);
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            Name qname = this.session.getQName(name);
            return this.getNodeTypeRegistry().isRegistered(qname);
        }
        catch (NamespaceException e) {
            return false;
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid name: " + name, (Throwable)e);
        }
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] definitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<QNodeTypeDefinition> addedDefs = new ArrayList<QNodeTypeDefinition>();
        ArrayList<QNodeTypeDefinition> modifiedDefs = new ArrayList<QNodeTypeDefinition>();
        for (NodeTypeDefinition definition : definitions) {
            QNodeTypeDefinition def = this.toNodeTypeDef(definition);
            if (this.ntReg.isRegistered(def.getName())) {
                if (allowUpdate) {
                    modifiedDefs.add(def);
                    continue;
                }
                throw new NodeTypeExistsException(definition.getName());
            }
            addedDefs.add(def);
        }
        try {
            ArrayList<NodeType> result = new ArrayList<NodeType>();
            result.addAll(this.registerNodeTypes(addedDefs));
            for (QNodeTypeDefinition nodeTypeDef : modifiedDefs) {
                this.ntReg.reregisterNodeType(nodeTypeDef);
                result.add(this.getNodeType(nodeTypeDef.getName()));
            }
            return new NodeTypeIteratorAdapter(result);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new InvalidNodeTypeDefinitionException(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterNodeTypes(String[] names) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        for (String name : names) {
            try {
                ntNames.add(this.session.getQName(name));
            }
            catch (NamespaceException e) {
                throw new RepositoryException("Invalid name: " + name, (Throwable)e);
            }
            catch (NameException e) {
                throw new RepositoryException("Invalid name: " + name, (Throwable)e);
            }
        }
        this.getNodeTypeRegistry().unregisterNodeTypes(ntNames);
    }

    private QNodeTypeDefinition toNodeTypeDef(NodeTypeDefinition definition) throws InvalidNodeTypeDefinitionException, RepositoryException {
        return new QNodeTypeDefinitionImpl(definition, (NamePathResolver)this.session, QValueFactoryImpl.getInstance());
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("NodeTypeManager (" + this + ")");
        ps.println();
        this.ntReg.dump(ps);
    }
}

