/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeRegistry
implements NodeTypeRegistryListener {
    private static final Logger log = LoggerFactory.getLogger(PropertyTypeRegistry.class);
    private static final TypeMapping[] EMPTY = new TypeMapping[0];
    private final NodeTypeRegistry registry;
    private final Map<Name, TypeMapping[]> typeMapping = new HashMap<Name, TypeMapping[]>();

    public PropertyTypeRegistry(NodeTypeRegistry reg) {
        this.registry = reg;
        this.fillCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMapping[] getPropertyTypes(Name propName) {
        Map<Name, TypeMapping[]> map = this.typeMapping;
        synchronized (map) {
            TypeMapping[] types = this.typeMapping.get(propName);
            if (types != null) {
                return types;
            }
            return EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeRegistered(Name ntName) {
        try {
            QNodeTypeDefinition def = this.registry.getNodeTypeDef(ntName);
            QPropertyDefinition[] propDefs = def.getPropertyDefs();
            Map<Name, TypeMapping[]> map = this.typeMapping;
            synchronized (map) {
                for (QPropertyDefinition propDef : propDefs) {
                    int type = propDef.getRequiredType();
                    if (propDef.definesResidual() || type == 0) continue;
                    Name name = propDef.getName();
                    TypeMapping[] types = this.typeMapping.get(name);
                    if (types == null) {
                        types = new TypeMapping[1];
                    } else {
                        TypeMapping[] tmp = new TypeMapping[types.length + 1];
                        System.arraycopy(types, 0, tmp, 0, types.length);
                        types = tmp;
                    }
                    types[types.length - 1] = new TypeMapping(ntName, type, propDef.isMultiple());
                    this.typeMapping.put(name, types);
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            log.error("Unable to get newly registered node type definition for name: " + ntName);
        }
    }

    public void nodeTypeReRegistered(Name ntName) {
        this.nodeTypeUnregistered(ntName);
        this.nodeTypeRegistered(ntName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(Name ntName) {
        Map<Name, TypeMapping[]> map = this.typeMapping;
        synchronized (map) {
            HashMap<Name, TypeMapping[]> modified = new HashMap<Name, TypeMapping[]>();
            Iterator<Name> it = this.typeMapping.keySet().iterator();
            while (it.hasNext()) {
                Name propName = it.next();
                TypeMapping[] mapping = this.typeMapping.get(propName);
                ArrayList<TypeMapping> remove = null;
                for (TypeMapping tm : mapping) {
                    if (!tm.ntName.equals(ntName)) continue;
                    if (remove == null) {
                        remove = new ArrayList<TypeMapping>(mapping.length);
                    }
                    remove.add(tm);
                }
                if (remove == null) continue;
                it.remove();
                if (mapping.length == remove.size()) continue;
                ArrayList<TypeMapping> remaining = new ArrayList<TypeMapping>(Arrays.asList(mapping));
                remaining.removeAll(remove);
                modified.put(propName, remaining.toArray(new TypeMapping[remaining.size()]));
            }
            this.typeMapping.putAll(modified);
        }
    }

    private void fillCache() {
        for (Name ntName : this.registry.getRegisteredNodeTypes()) {
            this.nodeTypeRegistered(ntName);
        }
    }

    public static class TypeMapping {
        public final int type;
        final Name ntName;
        public final boolean isMultiValued;

        private TypeMapping(Name ntName, int type, boolean isMultiValued) {
            this.type = type;
            this.ntName = ntName;
            this.isMultiValued = isMultiValued;
        }
    }
}

