/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.security.Principal;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.SimpleCredentialsAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginModule.class);
    protected User user;
    private UserManager userManager;

    protected void doInit(CallbackHandler callbackHandler, Session session, Map options) throws LoginException {
        if (!(session instanceof SessionImpl)) {
            throw new LoginException("Unable to initialize LoginModule: SessionImpl expected.");
        }
        try {
            this.userManager = ((SessionImpl)session).getUserManager();
            log.debug("- UserManager -> '" + this.userManager.getClass().getName() + "'");
        }
        catch (RepositoryException e) {
            throw new LoginException("Unable to initialize LoginModule: " + e.getMessage());
        }
    }

    protected Principal getPrincipal(Credentials credentials) {
        Principal principal = null;
        String userId = this.getUserID(credentials);
        try {
            Authorizable authrz = this.userManager.getAuthorizable(userId);
            if (authrz != null && !authrz.isGroup()) {
                this.user = (User)authrz;
                principal = this.user.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while retrieving principal.", (Object)e.getMessage());
        }
        return principal;
    }

    protected Authentication getAuthentication(Principal principal, Credentials creds) throws RepositoryException {
        SimpleCredentialsAuthentication authentication;
        if (this.user != null && (authentication = new SimpleCredentialsAuthentication(this.user)).canHandle(creds)) {
            return authentication;
        }
        return null;
    }

    protected boolean impersonate(Principal principal, Credentials credentials) throws RepositoryException, FailedLoginException {
        Authorizable authrz = this.userManager.getAuthorizable(principal);
        if (authrz == null || authrz.isGroup()) {
            return false;
        }
        Subject impersSubject = this.getImpersonatorSubject(credentials);
        User user = (User)authrz;
        if (user.getImpersonation().allows(impersSubject)) {
            return true;
        }
        throw new FailedLoginException("attempt to impersonate denied for " + principal.getName());
    }
}

