/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultISMLocking
implements ISMLocking {
    private static final Logger log = LoggerFactory.getLogger(DefaultISMLocking.class);
    private final RWLock rwLock = new RWLock();

    public ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        return new ReadLockImpl(this.rwLock.readLock());
    }

    public ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        return new ISMLocking.WriteLock(){
            {
                DefaultISMLocking.this.rwLock.writeLock().acquire();
                DefaultISMLocking.this.rwLock.setActiveXid(TransactionContext.getCurrentXid());
            }

            public void release() {
                DefaultISMLocking.this.rwLock.writeLock().release();
            }

            public ISMLocking.ReadLock downgrade() throws InterruptedException {
                ReadLockImpl rLock = new ReadLockImpl(DefaultISMLocking.this.rwLock.readLock());
                this.release();
                return rLock;
            }
        };
    }

    private static final class RWLock
    extends ReentrantWriterPreferenceReadWriteLock {
        private Xid activeXid;

        private RWLock() {
        }

        protected boolean allowReader() {
            return TransactionContext.isCurrentXid(this.activeXid, this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread());
        }

        synchronized void setActiveXid(Xid xid) {
            boolean sameGTI;
            if (this.activeXid != null && xid != null && !(sameGTI = Arrays.equals(this.activeXid.getGlobalTransactionId(), xid.getGlobalTransactionId()))) {
                log.warn("Unable to set the ActiveXid while a other one is associated with a different GloalTransactionId with this RWLock.");
                return;
            }
            this.activeXid = xid;
        }

        protected synchronized WriterPreferenceReadWriteLock.Signaller endWrite() {
            --this.writeHolds_;
            if (this.writeHolds_ > 0L) {
                return null;
            }
            this.activeXid = null;
            this.activeWriter_ = null;
            if (this.waitingReaders_ > 0L && this.allowReader()) {
                return this.readerLock_;
            }
            if (this.waitingWriters_ > 0L) {
                return this.writerLock_;
            }
            return null;
        }
    }

    private static final class ReadLockImpl
    implements ISMLocking.ReadLock {
        private final Sync readLock;

        private ReadLockImpl(Sync readLock) throws InterruptedException {
            this.readLock = readLock;
            this.readLock.acquire();
        }

        public void release() {
            this.readLock.release();
        }
    }
}

