/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedItemOperations
extends ItemValidator {
    private static Logger log = LoggerFactory.getLogger(BatchedItemOperations.class);
    protected static final int COPY = 0;
    protected static final int CLONE = 1;
    protected static final int CLONE_REMOVE_EXISTING = 2;
    protected final UpdatableItemStateManager stateMgr;
    protected final SessionImpl session;

    public BatchedItemOperations(UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, LockManager lockMgr, SessionImpl session, HierarchyManager hierMgr) throws RepositoryException {
        super(ntReg, hierMgr, (PathResolver)session, lockMgr, session.getAccessManager(), session.getRetentionRegistry(), session.getItemManager());
        this.stateMgr = stateMgr;
        this.session = session;
    }

    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        this.stateMgr.destroy(state);
    }

    public void update() throws RepositoryException, IllegalStateException {
        try {
            this.stateMgr.update();
        }
        catch (ItemStateException ise) {
            String msg = "update operation failed";
            log.debug(msg, (Throwable)ise);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    public NodeId clone(Path srcPath, Path destPath) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        this.checkInEditMode();
        NodeState srcState = this.getNodeState(srcPath);
        Path.Element destName = destPath.getNameElement();
        Path destParentPath = destPath.getAncestor(1);
        NodeState destParentState = this.getNodeState(destParentPath);
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = "invalid destination path: " + this.safeGetJCRPath(destPath) + " (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        return this.clone(srcState, destParentState, destName.getName());
    }

    public NodeId clone(NodeState srcState, NodeState destParentState, Name destName) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        this.checkAddNode(destParentState, destName, srcState.getNodeTypeName(), 407);
        if (!this.isShareable(srcState)) {
            String msg = "Cloning inside a workspace is only allowed for shareable nodes. Node with type " + srcState.getNodeTypeName() + " is not shareable.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeId srcId = srcState.getNodeId();
        NodeId destParentId = destParentState.getNodeId();
        if (destParentId.equals(srcId) || this.hierMgr.isAncestor(srcId, destParentId)) {
            String msg = "Cloning Node with id " + srcId + " to parent with id " + destParentId + " would create a share cycle.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!srcState.addShare(destParentState.getNodeId())) {
            String msg = "Adding a shareable node with id (" + destParentState.getNodeId() + ") twice to the same parent is not supported.";
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        destParentState.addChildNodeEntry(destName, srcState.getNodeId());
        this.stateMgr.store(srcState);
        this.stateMgr.store(destParentState);
        return destParentState.getNodeId();
    }

    public NodeId copy(Path srcPath, Path destPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        return this.copy(srcPath, this.stateMgr, this.hierMgr, this.session.getAccessManager(), destPath, flag);
    }

    public NodeId copy(Path srcPath, ItemStateManager srcStateMgr, HierarchyManager srcHierMgr, AccessManager srcAccessMgr, Path destPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        this.checkInEditMode();
        NodeState srcState = this.getNodeState(srcStateMgr, srcHierMgr, srcPath);
        Path.Element destName = destPath.getNameElement();
        Path destParentPath = destPath.getAncestor(1);
        NodeState destParentState = this.getNodeState(destParentPath);
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = "invalid copy destination path: " + this.safeGetJCRPath(destPath) + " (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.stateMgr.store(destParentState);
        this.checkAddNode(destParentState, destName.getName(), srcState.getNodeTypeName(), 407);
        try {
            if (!srcAccessMgr.isGranted(srcPath, 1)) {
                throw new PathNotFoundException(this.safeGetJCRPath(srcPath));
            }
        }
        catch (ItemNotFoundException infe) {
            String msg = "internal error: failed to check access rights for " + this.safeGetJCRPath(srcPath);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        ReferenceChangeTracker refTracker = new ReferenceChangeTracker();
        NodeState newState = this.copyNodeState(srcState, srcPath, srcStateMgr, srcAccessMgr, destParentState.getNodeId(), flag, refTracker);
        destParentState.addChildNodeEntry(destName.getName(), newState.getNodeId());
        Iterator<Object> iter = refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            PropertyState prop = (PropertyState)iter.next();
            if (prop.getType() != 9 && prop.getType() != 10) continue;
            boolean modified = false;
            InternalValue[] values = prop.getValues();
            InternalValue[] newVals = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                NodeId adjusted = refTracker.getMappedId(values[i].getNodeId());
                if (adjusted != null) {
                    newVals[i] = InternalValue.create(adjusted);
                    modified = true;
                    continue;
                }
                newVals[i] = values[i];
            }
            if (!modified) continue;
            prop.setValues(newVals);
            this.stateMgr.store(prop);
        }
        refTracker.clear();
        this.stateMgr.store(newState);
        this.stateMgr.store(destParentState);
        return newState.getNodeId();
    }

    public NodeId move(Path srcPath, Path destPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("cannot move path " + this.safeGetJCRPath(srcPath) + " because manager is not in edit mode");
        }
        try {
            if (srcPath.isAncestorOf(destPath)) {
                String msg = this.safeGetJCRPath(destPath) + ": invalid destination path" + " (cannot be descendant of source path)";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path for move: " + this.safeGetJCRPath(destPath);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        Path.Element srcName = srcPath.getNameElement();
        Path srcParentPath = srcPath.getAncestor(1);
        NodeState target = this.getNodeState(srcPath);
        NodeState srcParent = this.getNodeState(srcParentPath);
        Path.Element destName = destPath.getNameElement();
        Path destParentPath = destPath.getAncestor(1);
        NodeState destParent = this.getNodeState(destParentPath);
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = this.safeGetJCRPath(destPath) + ": invalid destination path" + " (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        HierarchyManagerImpl hierMgr = (HierarchyManagerImpl)this.hierMgr;
        if (hierMgr.isShareAncestor(target.getNodeId(), destParent.getNodeId())) {
            String msg = this.safeGetJCRPath(destPath) + ": invalid destination path" + " (share cycle detected)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.checkRemoveNode(target, srcParent.getNodeId(), 407);
        this.checkAddNode(destParent, destName.getName(), target.getNodeTypeName(), 407);
        boolean renameOnly = srcParent.getNodeId().equals(destParent.getNodeId());
        int srcNameIndex = srcName.getIndex();
        if (srcNameIndex == 0) {
            srcNameIndex = 1;
        }
        if (renameOnly) {
            destParent.renameChildNodeEntry(srcName.getName(), srcNameIndex, destName.getName());
        } else {
            if (target.isShareable()) {
                String msg = "Moving a shareable node (" + this.safeGetJCRPath(srcPath) + ") is not supported.";
                log.debug(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            if (srcParent.removeChildNodeEntry(target.getNodeId())) {
                target.setParentId(destParent.getNodeId());
                destParent.addChildNodeEntry(destName.getName(), target.getNodeId());
            }
        }
        this.stateMgr.store(target);
        if (renameOnly) {
            this.stateMgr.store(srcParent);
        } else {
            this.stateMgr.store(destParent);
            this.stateMgr.store(srcParent);
        }
        return target.getNodeId();
    }

    public void removeNode(Path nodePath) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("cannot remove node (" + this.safeGetJCRPath(nodePath) + ") because manager is not in edit mode");
        }
        NodeState target = this.getNodeState(nodePath);
        NodeId parentId = target.getParentId();
        this.checkRemoveNode(target, parentId, 415);
        this.removeNodeState(target);
    }

    public void checkAddNode(NodeState parentState, Name nodeName, Name nodeTypeName, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, RepositoryException {
        Path parentPath = this.hierMgr.getPath(parentState.getNodeId());
        if ((options & 2) == 2) {
            this.verifyUnlocked(parentPath);
        }
        if ((options & 4) == 4) {
            this.verifyCheckedOut(parentPath);
        }
        if ((options & 1) == 1) {
            if (!this.accessMgr.isGranted(parentPath, 1)) {
                throw new ItemNotFoundException(this.safeGetJCRPath(parentState.getNodeId()));
            }
            if (!this.accessMgr.isGranted(parentPath, nodeName, 4)) {
                throw new AccessDeniedException(this.safeGetJCRPath(parentState.getNodeId()) + ": not allowed to add child node");
            }
            if (!this.accessMgr.isGranted(parentPath, nodeName, 128)) {
                throw new AccessDeniedException(this.safeGetJCRPath(parentState.getNodeId()) + ": not allowed to add child node");
            }
        }
        if ((options & 0x10) == 16) {
            QNodeDefinition parentDef = this.itemMgr.getDefinition(parentState).unwrap();
            if (parentDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(parentState.getNodeId()) + ": cannot add child node to protected parent node");
            }
            EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
            entParent.checkAddNodeConstraints(nodeName, nodeTypeName, this.ntReg);
            QNodeDefinition newNodeDef = this.findApplicableNodeDefinition(nodeName, nodeTypeName, parentState);
            if (parentState.hasChildNodeEntry(nodeName)) {
                NodeState conflictingState;
                ChildNodeEntry entry = parentState.getChildNodeEntry(nodeName, 1);
                NodeId conflictingId = entry.getId();
                try {
                    conflictingState = (NodeState)this.stateMgr.getItemState(conflictingId);
                }
                catch (ItemStateException ise) {
                    String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(conflictingId);
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
                QNodeDefinition conflictingTargetDef = this.itemMgr.getDefinition(conflictingState).unwrap();
                if (!conflictingTargetDef.allowsSameNameSiblings() || !newNodeDef.allowsSameNameSiblings()) {
                    throw new ItemExistsException("cannot add child node '" + nodeName.getLocalName() + "' to " + this.safeGetJCRPath(parentState.getNodeId()) + ": colliding with same-named existing node");
                }
            }
        }
        if ((options & 0x80) == 128 && this.retentionReg.hasEffectiveHold(parentPath, false)) {
            throw new RepositoryException("Unable to add node. Parent is affected by a hold.");
        }
        if ((options & 0x100) == 256 && this.retentionReg.hasEffectiveRetention(parentPath, false)) {
            throw new RepositoryException("Unable to add node. Parent is affected by a retention.");
        }
    }

    public void checkRemoveNode(NodeState targetState, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException {
        this.checkRemoveNode(targetState, targetState.getParentId(), options);
    }

    public void checkRemoveNode(NodeState targetState, NodeId parentId, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException {
        NodeId targetId;
        EffectiveNodeType ent;
        if (targetState.getParentId() == null) {
            throw new ConstraintViolationException("cannot remove root node");
        }
        Path targetPath = this.hierMgr.getPath(targetState.getNodeId());
        NodeState parentState = this.getNodeState(parentId);
        Path parentPath = this.hierMgr.getPath(parentId);
        if ((options & 2) == 2) {
            this.verifyUnlocked(parentPath);
        }
        if ((options & 4) == 4) {
            this.verifyCheckedOut(parentPath);
        }
        if ((options & 1) == 1) {
            try {
                if (!this.accessMgr.isGranted(targetPath, 1)) {
                    throw new PathNotFoundException(this.safeGetJCRPath(targetPath));
                }
                if (!this.accessMgr.isGranted(targetPath, 8)) {
                    throw new AccessDeniedException(this.safeGetJCRPath(targetPath) + ": not allowed to remove node");
                }
            }
            catch (ItemNotFoundException infe) {
                String msg = "internal error: failed to check access rights for " + this.safeGetJCRPath(targetPath);
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)infe);
            }
        }
        if ((options & 0x10) == 16) {
            QNodeDefinition parentDef = this.itemMgr.getDefinition(parentState).unwrap();
            if (parentDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(parentId) + ": cannot remove child node of protected parent node");
            }
            QNodeDefinition targetDef = this.itemMgr.getDefinition(targetState).unwrap();
            if (targetDef.isMandatory()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(targetPath) + ": cannot remove mandatory node");
            }
            if (targetDef.isProtected()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(targetPath) + ": cannot remove protected node");
            }
        }
        if ((options & 8) == 8 && (ent = this.getEffectiveNodeType(targetState)).includesNodeType(NameConstants.MIX_REFERENCEABLE) && this.stateMgr.hasNodeReferences(targetId = targetState.getNodeId())) {
            try {
                NodeReferences refs = this.stateMgr.getNodeReferences(targetId);
                if (refs.hasReferences()) {
                    throw new ReferentialIntegrityException(this.safeGetJCRPath(targetPath) + ": cannot remove node with references");
                }
            }
            catch (ItemStateException ise) {
                String msg = "internal error: failed to check references on " + this.safeGetJCRPath(targetPath);
                log.error(msg, (Throwable)ise);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        if ((options & 0x80) == 128 && this.retentionReg.hasEffectiveHold(targetPath, true)) {
            throw new RepositoryException("Unable to perform removal. Node is affected by a hold.");
        }
        if ((options & 0x100) == 256 && this.retentionReg.hasEffectiveRetention(targetPath, true)) {
            throw new RepositoryException("Unable to perform removal. Node is affected by a retention.");
        }
    }

    public void verifyCanWrite(Path nodePath) throws PathNotFoundException, AccessDeniedException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        NodeState node = this.getNodeState(nodePath);
        if (!this.accessMgr.isGranted(nodePath, 1)) {
            throw new PathNotFoundException(this.safeGetJCRPath(node.getNodeId()));
        }
        this.verifyUnlocked(nodePath);
        this.verifyNotProtected(nodePath);
        this.verifyCheckedOut(nodePath);
        if (this.retentionReg.hasEffectiveHold(nodePath, false)) {
            throw new RepositoryException("Unable to write. Node is affected by a hold.");
        }
        if (this.retentionReg.hasEffectiveRetention(nodePath, false)) {
            throw new RepositoryException("Unable to write. Node is affected by a retention.");
        }
    }

    public void verifyCanRead(Path nodePath) throws PathNotFoundException, RepositoryException {
        if (!this.accessMgr.isGranted(nodePath, 1)) {
            throw new PathNotFoundException(this.safeGetJCRPath(nodePath));
        }
    }

    public NodeState createNodeState(NodeState parent, Name nodeName, Name nodeTypeName, Name[] mixinNames, NodeId id) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("cannot create node state for " + nodeName + " because manager is not in edit mode");
        }
        QNodeDefinition def = this.findApplicableNodeDefinition(nodeName, nodeTypeName, parent);
        return this.createNodeState(parent, nodeName, nodeTypeName, mixinNames, id, def);
    }

    public NodeState createNodeState(NodeState parent, Name nodeName, Name nodeTypeName, Name[] mixinNames, NodeId id, QNodeDefinition def) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        if (!def.allowsSameNameSiblings() && parent.hasChildNodeEntry(nodeName)) {
            NodeId errorId = parent.getChildNodeEntry(nodeName, 1).getId();
            throw new ItemExistsException(this.safeGetJCRPath(errorId));
        }
        if (id == null) {
            id = new NodeId();
        }
        if (nodeTypeName == null && (nodeTypeName = def.getDefaultPrimaryType()) == null) {
            String msg = "an applicable node type could not be determined for " + nodeName;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        NodeState node = this.stateMgr.createNew(id, nodeTypeName, parent.getNodeId());
        if (mixinNames != null && mixinNames.length > 0) {
            node.setMixinTypeNames(new HashSet<Name>(Arrays.asList(mixinNames)));
        }
        parent.addChildNodeEntry(nodeName, id);
        EffectiveNodeType ent = this.getEffectiveNodeType(node);
        if (ent.includesNodeType(NameConstants.MIX_SHAREABLE)) {
            node.addShare(parent.getNodeId());
        }
        if (!node.getMixinTypeNames().isEmpty()) {
            QPropertyDefinition pd = ent.getApplicablePropertyDef(NameConstants.JCR_MIXINTYPES, 7, true);
            this.createPropertyState(node, pd.getName(), pd.getRequiredType(), pd);
        }
        for (QPropertyDefinition qPropertyDefinition : ent.getAutoCreatePropDefs()) {
            this.createPropertyState(node, qPropertyDefinition.getName(), qPropertyDefinition.getRequiredType(), qPropertyDefinition);
        }
        for (QPropertyDefinition qPropertyDefinition : ent.getAutoCreateNodeDefs()) {
            this.createNodeState(node, qPropertyDefinition.getName(), qPropertyDefinition.getDefaultPrimaryType(), null, null, (QNodeDefinition)qPropertyDefinition);
        }
        this.stateMgr.store(node);
        this.stateMgr.store(parent);
        return node;
    }

    public PropertyState createPropertyState(NodeState parent, Name propName, int type, int numValues) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        QPropertyDefinition def;
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("cannot create property state for " + propName + " because manager is not in edit mode");
        }
        if (numValues == 1) {
            try {
                def = this.findApplicablePropertyDefinition(propName, type, false, parent);
            }
            catch (ConstraintViolationException cve) {
                def = this.findApplicablePropertyDefinition(propName, type, true, parent);
            }
        } else {
            def = this.findApplicablePropertyDefinition(propName, type, true, parent);
        }
        return this.createPropertyState(parent, propName, type, def);
    }

    public PropertyState createPropertyState(NodeState parent, Name propName, int type, QPropertyDefinition def) throws ItemExistsException, RepositoryException {
        if (parent.hasPropertyName(propName)) {
            PropertyId errorId = new PropertyId(parent.getNodeId(), propName);
            throw new ItemExistsException(this.safeGetJCRPath(errorId));
        }
        PropertyState prop = this.stateMgr.createNew(propName, parent.getNodeId());
        if (def.getRequiredType() != 0) {
            prop.setType(def.getRequiredType());
        } else if (type != 0) {
            prop.setType(type);
        } else {
            prop.setType(1);
        }
        prop.setMultiValued(def.isMultiple());
        InternalValue[] genValues = this.session.getNodeTypeInstanceHandler().computeSystemGeneratedPropertyValues(parent, def);
        if (genValues != null) {
            prop.setValues(genValues);
        } else if (def.getDefaultValues() != null) {
            prop.setValues(InternalValue.create(def.getDefaultValues()));
        }
        parent.addPropertyName(propName);
        this.stateMgr.store(parent);
        return prop;
    }

    public void removeNodeState(NodeState target) throws RepositoryException {
        NodeId parentId = target.getParentId();
        if (parentId == null) {
            String msg = "root node cannot be removed";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.recursiveRemoveNodeState(target);
        NodeState parent = this.getNodeState(parentId);
        parent.removeChildNodeEntry(target.getNodeId());
        this.stateMgr.store(parent);
    }

    public NodeState getNodeState(Path nodePath) throws PathNotFoundException, RepositoryException {
        return this.getNodeState(this.stateMgr, this.hierMgr, nodePath);
    }

    public NodeState getNodeState(NodeId id) throws ItemNotFoundException, RepositoryException {
        return (NodeState)this.getItemState(this.stateMgr, id);
    }

    public PropertyState getPropertyState(PropertyId id) throws ItemNotFoundException, RepositoryException {
        return (PropertyState)this.getItemState(this.stateMgr, id);
    }

    public ItemState getItemState(ItemId id) throws ItemNotFoundException, RepositoryException {
        return this.getItemState(this.stateMgr, id);
    }

    protected void verifyCheckedOut(Path nodePath) throws PathNotFoundException, VersionException, RepositoryException {
        PropertyState propState;
        NodeState nodeState = this.getNodeState(nodePath);
        while (!nodeState.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) {
            if (nodePath.denotesRoot()) {
                return;
            }
            nodePath = nodePath.getAncestor(1);
            nodeState = this.getNodeState(nodePath);
        }
        PropertyId propId = new PropertyId(nodeState.getNodeId(), NameConstants.JCR_ISCHECKEDOUT);
        try {
            propState = (PropertyState)this.stateMgr.getItemState(propId);
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(propId);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        boolean checkedOut = propState.getValues()[0].getBoolean();
        if (!checkedOut) {
            throw new VersionException(this.safeGetJCRPath(nodePath) + " is checked-in");
        }
    }

    protected void verifyUnlocked(Path nodePath) throws LockException, RepositoryException {
        this.lockMgr.checkLock(nodePath, (Session)this.session);
    }

    protected void verifyNotProtected(Path nodePath) throws PathNotFoundException, ConstraintViolationException, RepositoryException {
        NodeState node = this.getNodeState(nodePath);
        if (this.itemMgr.getDefinition(node).isProtected()) {
            throw new ConstraintViolationException(this.safeGetJCRPath(nodePath) + ": node is protected");
        }
    }

    protected NodeState getNodeState(ItemStateManager srcStateMgr, HierarchyManager srcHierMgr, Path nodePath) throws PathNotFoundException, RepositoryException {
        try {
            NodeId id = srcHierMgr.resolveNodePath(nodePath);
            if (id == null) {
                throw new PathNotFoundException(this.safeGetJCRPath(nodePath));
            }
            return (NodeState)this.getItemState(srcStateMgr, id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(this.safeGetJCRPath(nodePath));
        }
    }

    protected ItemState getItemState(ItemStateManager srcStateMgr, ItemId id) throws ItemNotFoundException, RepositoryException {
        try {
            return srcStateMgr.getItemState(id);
        }
        catch (NoSuchItemStateException nsise) {
            throw new ItemNotFoundException(this.safeGetJCRPath(id));
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to retrieve state of " + this.safeGetJCRPath(id);
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    private void recursiveRemoveNodeState(NodeState targetState) throws RepositoryException {
        AbstractCollection tmp;
        if (targetState.hasChildNodeEntries()) {
            tmp = new ArrayList<ChildNodeEntry>(targetState.getChildNodeEntries());
            for (int i = ((ArrayList)tmp).size() - 1; i >= 0; --i) {
                ChildNodeEntry entry = (ChildNodeEntry)((ArrayList)tmp).get(i);
                NodeId nodeId = entry.getId();
                try {
                    NodeState nodeState = (NodeState)this.stateMgr.getItemState(nodeId);
                    this.checkRemoveNode(nodeState, targetState.getNodeId(), 391);
                    this.recursiveRemoveNodeState(nodeState);
                }
                catch (ItemStateException ise) {
                    String msg = "internal error: failed to retrieve state of " + nodeId;
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
                targetState.removeChildNodeEntry(entry.getName(), entry.getIndex());
            }
        }
        tmp = new HashSet<Name>(targetState.getPropertyNames());
        for (Name propName : tmp) {
            PropertyId propId = new PropertyId(targetState.getNodeId(), propName);
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
                targetState.removePropertyName(propId.getName());
                this.stateMgr.destroy(propState);
            }
            catch (ItemStateException ise) {
                String msg = "internal error: failed to retrieve state of " + propId;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        targetState.setParentId(null);
        this.stateMgr.destroy(targetState.getOverlayedState());
    }

    private NodeState copyNodeState(NodeState srcState, Path srcPath, ItemStateManager srcStateMgr, AccessManager srcAccessMgr, NodeId destParentId, int flag, ReferenceChangeTracker refTracker) throws RepositoryException {
        try {
            NodeId id;
            EffectiveNodeType ent = this.getEffectiveNodeType(srcState);
            boolean referenceable = ent.includesNodeType(NameConstants.MIX_REFERENCEABLE);
            boolean versionable = ent.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE);
            boolean fullVersionable = ent.includesNodeType(NameConstants.MIX_VERSIONABLE);
            boolean shareable = ent.includesNodeType(NameConstants.MIX_SHAREABLE);
            switch (flag) {
                case 0: {
                    id = new NodeId();
                    if (!referenceable) break;
                    refTracker.mappedId(srcState.getNodeId(), id);
                    break;
                }
                case 1: {
                    if (!referenceable) {
                        id = new NodeId();
                        break;
                    }
                    id = srcState.getNodeId();
                    if (!this.stateMgr.hasItemState(id)) break;
                    throw new ItemExistsException(this.safeGetJCRPath(id));
                }
                case 2: {
                    if (!referenceable) {
                        id = new NodeId();
                        break;
                    }
                    id = srcState.getNodeId();
                    if (!this.stateMgr.hasItemState(id)) break;
                    NodeState existingState = (NodeState)this.stateMgr.getItemState(id);
                    if (id.equals(destParentId) || this.hierMgr.isAncestor(id, destParentId)) {
                        String msg = "cannot remove node " + this.safeGetJCRPath(srcPath) + " because it is an ancestor of the destination";
                        log.debug(msg);
                        throw new RepositoryException(msg);
                    }
                    this.checkRemoveNode(existingState, 407);
                    this.removeNodeState(existingState);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown flag for copying node state: " + flag);
                }
            }
            NodeState newState = this.stateMgr.createNew(id, srcState.getNodeTypeName(), destParentId);
            newState.setMixinTypeNames(srcState.getMixinTypeNames());
            if (shareable) {
                newState.addShare(destParentId);
            }
            for (ChildNodeEntry entry : srcState.getChildNodeEntries()) {
                NodeId mappedId;
                Path srcChildPath = PathFactoryImpl.getInstance().create(srcPath, entry.getName(), true);
                if (!srcAccessMgr.isGranted(srcChildPath, 1)) continue;
                NodeId nodeId = entry.getId();
                NodeState srcChildState = (NodeState)srcStateMgr.getItemState(nodeId);
                if (srcChildState.isShareable() && (mappedId = refTracker.getMappedId(srcChildState.getNodeId())) != null && this.stateMgr.hasItemState(mappedId)) {
                    NodeState destState = (NodeState)this.stateMgr.getItemState(mappedId);
                    if (!destState.isShareable()) {
                        String msg = "Remapped child (" + this.safeGetJCRPath(srcPath) + ") is not shareable.";
                        throw new ItemStateException(msg);
                    }
                    if (!destState.addShare(id)) {
                        String msg = "Unable to add share to node: " + id;
                        throw new ItemStateException(msg);
                    }
                    this.stateMgr.store(destState);
                    newState.addChildNodeEntry(entry.getName(), mappedId);
                    continue;
                }
                NodeState newChildState = this.copyNodeState(srcChildState, srcChildPath, srcStateMgr, srcAccessMgr, id, flag, refTracker);
                this.stateMgr.store(newChildState);
                newState.addChildNodeEntry(entry.getName(), newChildState.getNodeId());
            }
            VersionHistoryInfo history = null;
            if (versionable && flag == 0) {
                NodeId copiedFrom = null;
                if (fullVersionable) {
                    PropertyId propId = new PropertyId(srcState.getNodeId(), NameConstants.JCR_BASEVERSION);
                    PropertyState prop = (PropertyState)srcStateMgr.getItemState(propId);
                    copiedFrom = prop.getValues()[0].getNodeId();
                }
                InternalVersionManager manager = this.session.getInternalVersionManager();
                history = manager.getVersionHistory((Session)this.session, newState, copiedFrom);
            }
            for (Name propName : srcState.getPropertyNames()) {
                PropertyState srcChildState;
                QPropertyDefinition def;
                PropertyId propId;
                Path propPath = PathFactoryImpl.getInstance().create(srcPath, propName, true);
                if (!srcAccessMgr.canRead(propPath, propId = new PropertyId(srcState.getNodeId(), propName)) || (def = ent.getApplicablePropertyDef((srcChildState = (PropertyState)srcStateMgr.getItemState(propId)).getName(), srcChildState.getType(), srcChildState.isMultiValued())).getDeclaringNodeType().equals(NameConstants.MIX_LOCKABLE)) continue;
                PropertyState newChildState = this.copyPropertyState(srcChildState, id, propName, def);
                if (history != null) {
                    if (fullVersionable) {
                        InternalValue value;
                        if (propName.equals(NameConstants.JCR_VERSIONHISTORY)) {
                            value = InternalValue.create(history.getVersionHistoryId());
                            newChildState.setValues(new InternalValue[]{value});
                        } else if (propName.equals(NameConstants.JCR_BASEVERSION) || propName.equals(NameConstants.JCR_PREDECESSORS)) {
                            value = InternalValue.create(history.getRootVersionId());
                            newChildState.setValues(new InternalValue[]{value});
                        } else if (propName.equals(NameConstants.JCR_ISCHECKEDOUT)) {
                            newChildState.setValues(new InternalValue[]{InternalValue.create(true)});
                        }
                    } else if (propName.equals(NameConstants.JCR_ISCHECKEDOUT)) {
                        newChildState.setValues(new InternalValue[]{InternalValue.create(true)});
                    }
                }
                if (newChildState.getType() == 9 || newChildState.getType() == 10) {
                    refTracker.processedReference(newChildState);
                }
                this.stateMgr.store(newChildState);
                newState.addPropertyName(propName);
            }
            return newState;
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to copy state of " + srcState.getNodeId();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    private PropertyState copyPropertyState(PropertyState srcState, NodeId parentId, Name propName, QPropertyDefinition def) throws RepositoryException {
        PropertyState newState = this.stateMgr.createNew(propName, parentId);
        newState.setType(srcState.getType());
        newState.setMultiValued(srcState.isMultiValued());
        InternalValue[] values = srcState.getValues();
        if (values != null) {
            if (propName.equals(NameConstants.JCR_UUID) && def.getDeclaringNodeType().equals(NameConstants.MIX_REFERENCEABLE)) {
                newState.setValues(new InternalValue[]{InternalValue.create(parentId.toString())});
            } else {
                InternalValue[] newValues = new InternalValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = values[i].createCopy();
                }
                newState.setValues(newValues);
            }
        }
        return newState;
    }

    private void checkInEditMode() throws IllegalStateException {
        if (!this.stateMgr.inEditMode()) {
            throw new IllegalStateException("not in edit mode");
        }
    }

    private boolean isShareable(NodeState state) throws RepositoryException {
        Name primary = state.getNodeTypeName();
        Set<Name> mixins = state.getMixinTypeNames();
        if (mixins.contains(NameConstants.MIX_SHAREABLE)) {
            return true;
        }
        try {
            EffectiveNodeType type = this.ntReg.getEffectiveNodeType(primary, mixins);
            return type.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }
}

