/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DocId {
    static final int[] EMPTY = new int[0];
    static final DocId NULL = new DocId(){

        final int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) {
            return EMPTY;
        }

        final DocId applyOffset(int offset) {
            return this;
        }

        final boolean isValid(BitSet deleted) {
            return true;
        }
    };

    DocId() {
    }

    abstract int[] getDocumentNumbers(MultiIndexReader var1, int[] var2) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        return new PlainDocId(docNumber);
    }

    static DocId create(String uuid) {
        return DocId.create(new NodeId(uuid));
    }

    static DocId create(NodeId id) {
        return new UUIDDocId(id);
    }

    static DocId create(String[] uuids) {
        return new MultiUUIDDocId(uuids);
    }

    private static final class MultiUUIDDocId
    extends DocId {
        private final UUIDDocId[] docIds;

        MultiUUIDDocId(String[] uuids) {
            this.docIds = new UUIDDocId[uuids.length];
            for (int i = 0; i < uuids.length; ++i) {
                this.docIds[i] = new UUIDDocId(new NodeId(uuids[i]));
            }
        }

        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) throws IOException {
            int[] tmp = new int[1];
            docNumbers = new int[this.docIds.length];
            for (int i = 0; i < docNumbers.length; ++i) {
                docNumbers[i] = this.docIds[i].getDocumentNumbers(reader, tmp)[0];
            }
            return docNumbers;
        }

        DocId applyOffset(int offset) {
            return this;
        }

        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("MultiUUIDDocId(");
            String separator = "";
            for (UUIDDocId docId : this.docIds) {
                sb.append(separator);
                separator = ", ";
                sb.append(docId.id);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private static final class UUIDDocId
    extends DocId {
        private static final Logger log = LoggerFactory.getLogger(UUIDDocId.class);
        private final NodeId id;
        private ForeignSegmentDocId doc;

        UUIDDocId(NodeId id) {
            this.id = id;
        }

        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) throws IOException {
            int realDoc = -1;
            ForeignSegmentDocId segDocId = this.doc;
            if (segDocId != null) {
                realDoc = reader.getDocumentNumber(segDocId);
            }
            if (realDoc == -1) {
                segDocId = reader.createDocId(this.id);
                if (segDocId != null) {
                    realDoc = reader.getDocumentNumber(segDocId);
                    this.doc = segDocId;
                } else {
                    log.warn("Unknown parent node with id {}", (Object)this.id);
                    return EMPTY;
                }
            }
            if (docNumbers.length == 1) {
                docNumbers[0] = realDoc;
                return docNumbers;
            }
            return new int[]{realDoc};
        }

        DocId applyOffset(int offset) {
            return this;
        }

        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            return "UUIDDocId(" + this.id + ")";
        }
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) {
            if (docNumbers.length == 1) {
                docNumbers[0] = this.docNumber;
                return docNumbers;
            }
            return new int[]{this.docNumber};
        }

        DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }
}

