/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class LazyTextExtractorField
extends AbstractField {
    private static final Logger log = LoggerFactory.getLogger(LazyTextExtractorField.class);
    private volatile String extract = null;

    public LazyTextExtractorField(Parser parser, InternalValue value, Metadata metadata, Executor executor, boolean highlighting) {
        super(FieldNames.FULLTEXT, highlighting ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, highlighting ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO);
        executor.execute(new ParsingTask(parser, value, metadata));
    }

    public synchronized String stringValue() {
        try {
            while (!this.isExtractorFinished()) {
                ((Object)((Object)this)).wait();
            }
            return this.extract;
        }
        catch (InterruptedException e) {
            log.error("Text extraction thread was interrupted", (Throwable)e);
            return "";
        }
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        return null;
    }

    public boolean isExtractorFinished() {
        return this.extract != null;
    }

    private synchronized void setExtractedText(String value) {
        this.extract = value;
        ((Object)((Object)this)).notify();
    }

    public void dispose() {
    }

    private class ParsingTask
    implements Runnable {
        private final Parser parser;
        private final InternalValue value;
        private final Metadata metadata;

        public ParsingTask(Parser parser, InternalValue value, Metadata metadata) {
            this.parser = parser;
            this.value = value;
            this.metadata = metadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BodyContentHandler handler = new BodyContentHandler();
            try {
                InputStream stream = this.value.getStream();
                try {
                    this.parser.parse(stream, (ContentHandler)handler, this.metadata);
                }
                finally {
                    stream.close();
                }
            }
            catch (Throwable t) {
                log.warn("Failed to extract text from a binary property", t);
            }
            finally {
                this.value.discard();
            }
            LazyTextExtractorField.this.setExtractedText(handler.toString());
        }
    }
}

