/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlObserver;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCollector
extends AccessControlObserver
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(EntryCollector.class);
    protected final SessionImpl systemSession;
    protected final NodeId rootID;
    private final ACLEditor systemEditor;
    private final String repPolicyName;

    protected EntryCollector(SessionImpl systemSession, ACLEditor systemEditor, NodeId rootID) throws RepositoryException {
        this.systemSession = systemSession;
        this.systemEditor = systemEditor;
        this.rootID = rootID;
        this.repPolicyName = systemSession.getJCRName(N_POLICY);
        ObservationManager observationMgr = systemSession.getWorkspace().getObservationManager();
        int events = 19;
        String[] ntNames = new String[]{systemSession.getJCRName(NT_REP_ACCESS_CONTROLLABLE), systemSession.getJCRName(NT_REP_ACL), systemSession.getJCRName(NT_REP_ACE)};
        observationMgr.addEventListener((EventListener)this, events, systemSession.getRootNode().getPath(), true, null, ntNames, true);
    }

    @Override
    protected void close() {
        super.close();
        try {
            this.systemSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while closing CachingEntryCollector", (Throwable)e);
        }
    }

    protected List<AccessControlEntry> collectEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        List<AccessControlEntry> entries;
        LinkedList userAces = new LinkedList();
        LinkedList groupAces = new LinkedList();
        NodeId next = node.getNodeId();
        while (next != null) {
            entries = this.getEntries(next);
            if (!entries.isEmpty() && filter != null) {
                filter.filterEntries(entries, userAces, groupAces);
            }
            next = this.getParentId(next);
        }
        entries = new ArrayList<AccessControlEntry>(userAces.size() + groupAces.size());
        entries.addAll(userAces);
        entries.addAll(groupAces);
        return entries;
    }

    protected List<AccessControlEntry> getEntries(NodeImpl node) throws RepositoryException {
        List<AccessControlEntry> entries;
        if (ACLProvider.isAccessControlled(node)) {
            NodeImpl aclNode = node.getNode(N_POLICY);
            entries = Arrays.asList(this.systemEditor.getACL(aclNode).getAccessControlEntries());
        } else {
            entries = Collections.emptyList();
        }
        return entries;
    }

    protected List<AccessControlEntry> getEntries(NodeId nodeId) throws RepositoryException {
        NodeImpl node = this.getNodeById(nodeId);
        return this.getEntries(node);
    }

    protected NodeId getParentId(NodeId nodeId) throws RepositoryException {
        NodeId parentId = this.rootID.equals(nodeId) ? null : this.getNodeById(nodeId).getParentId();
        return parentId;
    }

    NodeImpl getNodeById(NodeId nodeId) throws RepositoryException {
        return (NodeImpl)this.systemSession.getItemManager().getItem(nodeId);
    }

    private static NodeId accessControlledIdFromAclNode(Node aclNode) throws RepositoryException {
        return ((NodeImpl)aclNode.getParent()).getNodeId();
    }

    private static NodeId accessControlledIdFromAceNode(Node aceNode) throws RepositoryException {
        return ((NodeImpl)aceNode.getParent().getParent()).getNodeId();
    }

    private static void addModification(NodeId accessControllNodeId, int modType, Map<NodeId, Integer> modMap) {
        if (modMap.containsKey(accessControllNodeId)) {
            modMap.put(accessControllNodeId, modType | modMap.get(accessControllNodeId));
        } else {
            modMap.put(accessControllNodeId, modType);
        }
    }

    public void onEvent(EventIterator events) {
        HashMap<NodeId, Integer> modMap = new HashMap<NodeId, Integer>();
        block7: while (events.hasNext()) {
            try {
                Event ev = events.nextEvent();
                String identifier = ev.getIdentifier();
                String path = ev.getPath();
                switch (ev.getType()) {
                    case 1: {
                        NodeImpl n = (NodeImpl)this.systemSession.getNodeByIdentifier(identifier);
                        if (n.isNodeType(NT_REP_ACL)) {
                            EntryCollector.addModification(EntryCollector.accessControlledIdFromAclNode(n), 1, modMap);
                            break;
                        }
                        if (!n.isNodeType(NT_REP_ACE)) break;
                        EntryCollector.addModification(EntryCollector.accessControlledIdFromAceNode(n), 4, modMap);
                        break;
                    }
                    case 2: {
                        NodeImpl parent;
                        String parentPath = Text.getRelativeParent((String)path, (int)1);
                        if (this.systemSession.nodeExists(parentPath)) {
                            parent = (NodeImpl)this.systemSession.getNode(parentPath);
                            if (this.repPolicyName.equals(Text.getName((String)path))) {
                                EntryCollector.addModification(parent.getNodeId(), 2, modMap);
                                break;
                            }
                            if (!parent.isNodeType(NT_REP_ACL)) continue block7;
                            EntryCollector.addModification(EntryCollector.accessControlledIdFromAclNode(parent), 4, modMap);
                            break;
                        }
                        log.debug("Cannot process NODE_REMOVED event. Parent " + parentPath + " doesn't exist (anymore).");
                        break;
                    }
                    case 16: {
                        NodeImpl parent = (NodeImpl)this.systemSession.getNodeByIdentifier(identifier);
                        if (!parent.isNodeType(NT_REP_ACE)) break;
                        EntryCollector.addModification(EntryCollector.accessControlledIdFromAceNode(parent), 4, modMap);
                        break;
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Throwable)e);
            }
        }
        if (!modMap.isEmpty()) {
            this.notifyListeners(new AccessControlModifications(modMap));
        }
    }
}

