/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.NamedAccessControlPolicyImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAccessControlProvider
extends AbstractAccessControlProvider
implements UserConstants {
    private static Logger log = LoggerFactory.getLogger(UserAccessControlProvider.class);
    private final AccessControlPolicy policy = new NamedAccessControlPolicyImpl("userPolicy");
    private String groupsPath;
    private String usersPath;
    private Principal userAdminGroup;
    private Principal groupAdminGroup;
    private String userAdminGroupPath;
    private String groupAdminGroupPath;
    private String administratorsGroupPath;

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        return false;
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        UserManager uMgr;
        super.init(systemSession, configuration);
        if (systemSession instanceof SessionImpl) {
            Principal administrators;
            SessionImpl sImpl = (SessionImpl)systemSession;
            String userAdminName = configuration.containsKey("UserAdmin") ? configuration.get("UserAdmin").toString() : "UserAdmin";
            String groupAdminName = configuration.containsKey("GroupAdmin") ? configuration.get("GroupAdmin").toString() : "GroupAdmin";
            uMgr = sImpl.getUserManager();
            this.userAdminGroup = UserAccessControlProvider.initGroup(uMgr, userAdminName);
            if (this.userAdminGroup != null && this.userAdminGroup instanceof ItemBasedPrincipal) {
                this.userAdminGroupPath = ((ItemBasedPrincipal)this.userAdminGroup).getPath();
            }
            this.groupAdminGroup = UserAccessControlProvider.initGroup(uMgr, groupAdminName);
            if (this.groupAdminGroup != null && this.groupAdminGroup instanceof ItemBasedPrincipal) {
                this.groupAdminGroupPath = ((ItemBasedPrincipal)this.groupAdminGroup).getPath();
            }
            if ((administrators = UserAccessControlProvider.initGroup(uMgr, "administrators")) != null && administrators instanceof ItemBasedPrincipal) {
                this.administratorsGroupPath = ((ItemBasedPrincipal)administrators).getPath();
            }
        } else {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.usersPath = uMgr instanceof UserManagerImpl ? ((UserManagerImpl)uMgr).getUsersPath() : "/rep:security/rep:authorizables/rep:users";
        this.groupsPath = uMgr instanceof UserManagerImpl ? ((UserManagerImpl)uMgr).getGroupsPath() : "/rep:security/rep:authorizables/rep:groups";
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        return new AccessControlPolicy[]{this.policy};
    }

    @Override
    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        ItemBasedPrincipal userPrincipal = this.getUserPrincipal(principals);
        NodeImpl userNode = this.getUserNode(userPrincipal);
        if (userNode == null) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionsImpl(principals, userNode.getPath());
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        return true;
    }

    private ItemBasedPrincipal getUserPrincipal(Set<Principal> principals) {
        try {
            UserManager uMgr = this.session.getUserManager();
            for (Principal p : principals) {
                if (p instanceof Group || !(p instanceof ItemBasedPrincipal) || uMgr.getAuthorizable(p) == null) continue;
                return (ItemBasedPrincipal)p;
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error while retrieving user principal", (Object)e.getMessage());
        }
        return null;
    }

    private NodeImpl getUserNode(ItemBasedPrincipal principal) {
        NodeImpl userNode = null;
        if (principal != null) {
            try {
                String path = principal.getPath();
                userNode = (NodeImpl)this.session.getNode(path);
            }
            catch (RepositoryException e) {
                log.warn("Error while retrieving user node.", (Object)e.getMessage());
            }
        }
        return userNode;
    }

    private Node getExistingNode(Path path) throws RepositoryException {
        String absPath = this.resolver.getJCRPath(path.getNormalizedPath());
        if (this.session.nodeExists(absPath)) {
            return this.session.getNode(absPath);
        }
        if (this.session.propertyExists(absPath)) {
            return this.session.getProperty(absPath).getParent();
        }
        String pPath = Text.getRelativeParent((String)absPath, (int)1);
        while (!"/".equals(pPath)) {
            if (this.session.nodeExists(pPath)) {
                return this.session.getNode(pPath);
            }
            pPath = Text.getRelativeParent((String)pPath, (int)1);
        }
        throw new ItemNotFoundException("Unable to determine permissions: No item and no existing parent for target path " + absPath);
    }

    private int getPrivilegeBits(String privName) throws RepositoryException {
        Privilege[] privs = new Privilege[]{this.session.getAccessControlManager().privilegeFromName(privName)};
        return PrivilegeRegistry.getBits(privs);
    }

    private static boolean containsGroup(Set<Principal> principals, Principal group) {
        Iterator<Principal> it = principals.iterator();
        while (it.hasNext() && group != null) {
            Principal p = it.next();
            if (!p.getName().equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    private static Principal initGroup(UserManager uMgr, String principalName) {
        PrincipalImpl prnc = new PrincipalImpl(principalName);
        try {
            Authorizable auth = uMgr.getAuthorizable((Principal)((Object)prnc));
            if (auth == null) {
                auth = uMgr.createGroup((Principal)((Object)prnc));
            } else if (!auth.isGroup()) {
                log.warn("Cannot create group '" + principalName + "'; User with that principal already exists.");
                auth = null;
            }
            if (auth != null) {
                return auth.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            log.error("Error while initializing user/group administrators", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompiledPermissionsImpl
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final String userNodePath;
        private boolean isUserAdmin;
        private boolean isGroupAdmin;

        protected CompiledPermissionsImpl(Set<Principal> principals, String userNodePath) throws RepositoryException {
            this.userNodePath = userNodePath;
            this.isUserAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.userAdminGroup);
            this.isGroupAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.groupAdminGroup);
            int events = 28;
            UserAccessControlProvider.this.observationMgr.addEventListener((EventListener)this, events, UserAccessControlProvider.this.groupsPath, true, null, null, false);
        }

        @Override
        protected AbstractCompiledPermissions.Result buildResult(Path path) throws RepositoryException {
            NodeImpl userNode = null;
            try {
                if (UserAccessControlProvider.this.session.nodeExists(this.userNodePath)) {
                    userNode = (NodeImpl)UserAccessControlProvider.this.session.getNode(this.userNodePath);
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            if (userNode == null) {
                log.debug("No node at " + this.userNodePath);
                return new AbstractCompiledPermissions.Result(0, 0, 0, 0);
            }
            int denies = 0;
            int allows = 1;
            String jcrPath = UserAccessControlProvider.this.resolver.getJCRPath(path.getNormalizedPath());
            boolean calcPrivs = UserAccessControlProvider.this.session.nodeExists(jcrPath);
            int privs = calcPrivs ? UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}read") : 0;
            if (Text.isDescendant((String)UserAccessControlProvider.this.usersPath, (String)jcrPath)) {
                NodeImpl node = (NodeImpl)UserAccessControlProvider.this.getExistingNode(path);
                if (node.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                    if (this.isUserAdmin) {
                        allows |= 0x9E;
                        if (calcPrivs) {
                            privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                        }
                    }
                } else {
                    boolean editingOwnUser = node.isSame(userNode);
                    if (editingOwnUser) {
                        allows |= 0x12;
                        if (calcPrivs) {
                            privs |= UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}modifyProperties");
                        }
                    } else if (this.isUserAdmin) {
                        allows |= 0x9E;
                        if (calcPrivs) {
                            privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                        }
                    }
                }
            } else if (Text.isDescendant((String)UserAccessControlProvider.this.groupsPath, (String)jcrPath) && this.isGroupAdmin && !jcrPath.startsWith(UserAccessControlProvider.this.administratorsGroupPath) && !jcrPath.startsWith(UserAccessControlProvider.this.userAdminGroupPath)) {
                if (jcrPath.equals(UserAccessControlProvider.this.groupAdminGroupPath)) {
                    allows |= 0x96;
                    if (calcPrivs) {
                        privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                        privs ^= UserAccessControlProvider.this.getPrivilegeBits("{http://www.jcp.org/jcr/1.0}removeNode");
                    }
                } else {
                    allows |= 0x9E;
                    if (calcPrivs) {
                        privs |= UserAccessControlProvider.this.getPrivilegeBits("{internal}write");
                    }
                }
            }
            return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
        }

        @Override
        public void close() {
            try {
                UserAccessControlProvider.this.observationMgr.removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
            super.close();
        }

        @Override
        public boolean grants(Path absPath, int permissions) throws RepositoryException {
            if (permissions == 1) {
                return true;
            }
            return super.grants(absPath, permissions);
        }

        @Override
        public boolean canReadAll() throws RepositoryException {
            return true;
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event ev = events.nextEvent();
                try {
                    String evPath = ev.getPath();
                    String repMembers = UserAccessControlProvider.this.session.getJCRName(UserConstants.P_MEMBERS);
                    if (!repMembers.equals(Text.getName((String)evPath))) continue;
                    Node userNode = UserAccessControlProvider.this.session.getNode(this.userNodePath);
                    String nodePath = Text.getRelativeParent((String)evPath, (int)1);
                    if (UserAccessControlProvider.this.userAdminGroupPath.equals(nodePath)) {
                        this.isUserAdmin = false;
                        if (ev.getType() != 8) {
                            Value[] vs = UserAccessControlProvider.this.session.getProperty(evPath).getValues();
                            for (int i = 0; i < vs.length && !this.isUserAdmin; ++i) {
                                this.isUserAdmin = userNode.getIdentifier().equals(vs[i].getString());
                            }
                        }
                    } else if (UserAccessControlProvider.this.groupAdminGroupPath.equals(nodePath)) {
                        this.isGroupAdmin = false;
                        if (ev.getType() != 8) {
                            Value[] vs = UserAccessControlProvider.this.session.getProperty(evPath).getValues();
                            for (int i = 0; i < vs.length && !this.isGroupAdmin; ++i) {
                                this.isGroupAdmin = userNode.getIdentifier().equals(vs[i].getString());
                            }
                        }
                    }
                    this.clearCache();
                    break;
                }
                catch (RepositoryException e) {
                    log.error("Internal error ", (Object)e.getMessage());
                }
            }
        }
    }
}

