/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationEntityResolver
implements EntityResolver {
    public static final EntityResolver INSTANCE = new ConfigurationEntityResolver();
    private final Map<String, String> publicIds = new HashMap<String, String>();
    private final Map<String, String> systemIds = new HashMap<String, String>();

    private ConfigurationEntityResolver() {
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.6//EN", "repository-2.6.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.6.dtd", "repository-2.6.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.6 Elements//EN", "repository-2.6-elements.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.6-elements.dtd", "repository-2.6-elements.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.4//EN", "repository-2.4.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.4.dtd", "repository-2.4.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.4 Elements//EN", "repository-2.4-elements.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.4-elements.dtd", "repository-2.4-elements.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.0//EN", "repository-2.0.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.0.dtd", "repository-2.0.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 2.0 Elements//EN", "repository-2.0-elements.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-2.0-elements.dtd", "repository-2.0-elements.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 1.6//EN", "repository-1.6.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-1.6.dtd", "repository-1.6.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 1.5//EN", "repository-1.5.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-1.5.dtd", "repository-1.5.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 1.4//EN", "repository-1.4.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-1.4.dtd", "repository-1.4.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 1.2//EN", "repository-1.2.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-1.2.dtd", "repository-1.2.dtd");
        this.publicIds.put("-//The Apache Software Foundation//DTD Jackrabbit 1.0//EN", "repository-1.0.dtd");
        this.systemIds.put("http://jackrabbit.apache.org/dtd/repository-1.0.dtd", "repository-1.0.dtd");
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream stream;
        String name = this.publicIds.get(publicId);
        if (name != null && (stream = this.getClass().getResourceAsStream(name)) != null) {
            return new InputSource(stream);
        }
        name = this.systemIds.get(systemId);
        if (name != null && (stream = this.getClass().getResourceAsStream(name)) != null) {
            return new InputSource(stream);
        }
        return null;
    }
}

