/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.HierarchyConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;

public class ChildNodeConstraint
extends HierarchyConstraint {
    public ChildNodeConstraint(ChildNodeImpl constraint, SelectorImpl selector) {
        super(constraint.getParentPath(), selector);
    }

    @Override
    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        NodeImpl parent;
        ScoreNode sn = row[this.getSelectorIndex(selectorNames)];
        if (sn == null) {
            return false;
        }
        SessionImpl session = context.getSession();
        try {
            parent = (NodeImpl)session.getNodeById(sn.getNodeId()).getParent();
        }
        catch (RepositoryException e) {
            return false;
        }
        return parent.getId().equals(this.getBaseNodeId(context));
    }
}

