/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;

public final class GroupPrincipals {
    private GroupPrincipals() {
    }

    public static boolean isGroup(Principal principal) {
        return principal instanceof Group || principal instanceof GroupPrincipal;
    }

    public static Enumeration<? extends Principal> members(Principal principal) {
        if (principal instanceof Group) {
            return ((Group)principal).members();
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }

    public static boolean isMember(Principal principal, Principal member) {
        if (principal instanceof Group) {
            return ((Group)principal).isMember(member);
        }
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).isMember(member);
        }
        return false;
    }
}

