/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ItemRemoveOperation
implements SessionWriteOperation<Object> {
    private final ItemImpl item;
    private final boolean checks;

    public ItemRemoveOperation(ItemImpl item, boolean checks) {
        this.item = item;
        this.checks = checks;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        if (this.item.getDepth() == 0) {
            throw new RepositoryException("Cannot remove the root node");
        }
        NodeImpl parentNode = (NodeImpl)this.item.getParent();
        if (this.checks) {
            ItemValidator validator = context.getItemValidator();
            validator.checkRemove(this.item, 400, 0);
            validator.checkModify(parentNode, 22, 0);
        }
        if (this.item.isNode()) {
            parentNode.removeChildNode((NodeId)this.item.getId());
        } else {
            parentNode.removeChildProperty(this.item.getPrimaryPath().getName());
        }
        return this;
    }

    public String toString() {
        return "item.remove()";
    }
}

