/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.BitSetENTCacheImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeDefDiff;
import org.apache.jackrabbit.spi.commons.nodetype.QNodeDefinitionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeRegistry
implements NodeTypeEventListener {
    private static Logger log = LoggerFactory.getLogger(NodeTypeRegistry.class);
    private static final String BUILTIN_NODETYPES_RESOURCE_PATH = "org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
    private static final String CUSTOM_NODETYPES_RESOURCE_NAME = "/nodetypes/custom_nodetypes.xml";
    private final FileSystemResource customNodeTypesResource;
    private final NodeTypeDefStore builtInNTDefs;
    private final NodeTypeDefStore customNTDefs;
    private EffectiveNodeTypeCache entCache;
    private final Map<Name, QNodeTypeDefinition> registeredNTDefs;
    private final QNodeDefinition rootNodeDef;
    private final NamespaceRegistry nsReg;
    private final Map<NodeTypeRegistryListener, NodeTypeRegistryListener> listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));
    private NodeTypeEventChannel eventChannel;

    public Name[] getRegisteredNodeTypes() {
        return this.registeredNTDefs.keySet().toArray(new Name[this.registeredNTDefs.size()]);
    }

    public synchronized EffectiveNodeType registerNodeType(QNodeTypeDefinition ntd) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.internalRegister(ntd);
        this.customNTDefs.add(ntd);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (this.eventChannel != null) {
            HashSet<QNodeTypeDefinition> ntDefs = new HashSet<QNodeTypeDefinition>();
            ntDefs.add(ntd);
            this.eventChannel.registered(ntDefs);
        }
        this.notifyRegistered(ntd.getName());
        return ent;
    }

    public void registerNodeTypes(Collection<QNodeTypeDefinition> ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.registerNodeTypes(ntDefs, false);
    }

    private synchronized void registerNodeTypes(Collection<QNodeTypeDefinition> ntDefs, boolean external) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs);
        for (QNodeTypeDefinition ntDef : ntDefs) {
            this.customNTDefs.add(ntDef);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (!external && this.eventChannel != null) {
            this.eventChannel.registered(ntDefs);
        }
        for (QNodeTypeDefinition ntDef : ntDefs) {
            this.notifyRegistered(ntDef.getName());
        }
    }

    public void unregisterNodeTypes(Set<Name> ntNames) throws NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(ntNames, false);
    }

    private synchronized void unregisterNodeTypes(Collection<Name> ntNames, boolean external) throws NoSuchNodeTypeException, RepositoryException {
        for (Name ntName : ntNames) {
            if (!this.registeredNTDefs.containsKey(ntName)) {
                throw new NoSuchNodeTypeException(ntName.toString());
            }
            if (this.builtInNTDefs.contains(ntName)) {
                throw new RepositoryException(ntName.toString() + ": can't unregister built-in node type.");
            }
            Set<Name> dependents = this.getDependentNodeTypes(ntName);
            dependents.removeAll(ntNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            for (Name dependent : dependents) {
                msg.append(dependent);
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        for (Name ntName : ntNames) {
            this.checkForReferencesInContent(ntName);
        }
        this.internalUnregister(ntNames);
        if (!external && this.eventChannel != null) {
            this.eventChannel.unregistered(ntNames);
        }
        for (Name ntName : ntNames) {
            this.customNTDefs.remove(ntName);
        }
        this.notifyUnregistered(ntNames);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
    }

    public void unregisterNodeType(Name ntName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        ntNames.add(ntName);
        this.unregisterNodeTypes(ntNames);
    }

    public EffectiveNodeType reregisterNodeType(QNodeTypeDefinition ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        return this.reregisterNodeType(ntd, false);
    }

    private synchronized EffectiveNodeType reregisterNodeType(QNodeTypeDefinition ntd, boolean external) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (!this.registeredNTDefs.containsKey(name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        if (this.builtInNTDefs.contains(name)) {
            throw new RepositoryException(name.toString() + ": can't reregister built-in node type.");
        }
        ntd = NodeTypeRegistry.checkNtBaseSubtyping(ntd, this.registeredNTDefs);
        NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs, this.nsReg, false);
        QNodeTypeDefinition ntdOld = this.registeredNTDefs.get(name);
        NodeTypeDefDiff diff = NodeTypeDefDiff.create((QNodeTypeDefinition)ntdOld, (QNodeTypeDefinition)ntd);
        if (!diff.isModified()) {
            return this.getEffectiveNodeType(name);
        }
        if (diff.isTrivial()) {
            this.internalUnregister(name);
            this.customNTDefs.remove(name);
            EffectiveNodeType entNew = this.internalRegister(ntd);
            this.customNTDefs.add(ntd);
            this.persistCustomNodeTypeDefs(this.customNTDefs);
            if (!external && this.eventChannel != null) {
                this.eventChannel.reregistered(ntd);
            }
            this.notifyReRegistered(name);
            return entNew;
        }
        String message = "The following node type change contains non-trivial changes.Up until now only trivial changes are supported. (see javadoc for " + NodeTypeDefDiff.class.getName() + "):\n" + diff.toString();
        throw new RepositoryException(message);
    }

    public EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return NodeTypeRegistry.getEffectiveNodeType(ntName, this.entCache, this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Name primary, Set<Name> mixins) throws NodeTypeConflictException, NoSuchNodeTypeException {
        if (mixins.isEmpty()) {
            return this.getEffectiveNodeType(primary);
        }
        Name[] names = new Name[mixins.size() + 1];
        mixins.toArray(names);
        names[names.length - 1] = primary;
        return NodeTypeRegistry.getEffectiveNodeType(names, this.entCache, this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Set<Name> mixins) throws NodeTypeConflictException, NoSuchNodeTypeException {
        Name[] names = new Name[mixins.size()];
        mixins.toArray(names);
        return NodeTypeRegistry.getEffectiveNodeType(names, this.entCache, this.registeredNTDefs);
    }

    public Set<Name> getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
        if (!this.registeredNTDefs.containsKey(nodeTypeName)) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        HashSet<Name> names = new HashSet<Name>();
        for (QNodeTypeDefinition ntd : this.registeredNTDefs.values()) {
            if (!ntd.getDependencies().contains(nodeTypeName)) continue;
            names.add(ntd.getName());
        }
        return names;
    }

    public QNodeTypeDefinition getNodeTypeDef(Name nodeTypeName) throws NoSuchNodeTypeException {
        QNodeTypeDefinition def = this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        return def;
    }

    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    public boolean isBuiltIn(Name nodeTypeName) {
        return this.builtInNTDefs.contains(nodeTypeName);
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeTypeRegistry (" + super.toString() + ")\n");
        builder.append("Registered NodeTypes:\n");
        for (QNodeTypeDefinition ntd : this.registeredNTDefs.values()) {
            QNodeDefinition[] nd;
            QPropertyDefinition[] pd;
            builder.append(ntd.getName());
            builder.append("\n");
            builder.append("\tSupertypes: " + Arrays.toString(ntd.getSupertypes()) + "\n");
            builder.append("\tMixin\t" + ntd.isMixin() + "\n");
            builder.append("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes() + "\n");
            builder.append("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()) + "\n");
            for (QPropertyDefinition aPd : pd = ntd.getPropertyDefs()) {
                builder.append("\tPropertyDefinition\n");
                builder.append(" (declared in " + aPd.getDeclaringNodeType() + ")\n");
                builder.append("\t\tName\t\t" + (aPd.definesResidual() ? "*" : aPd.getName().toString()) + "\n");
                String type = aPd.getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)aPd.getRequiredType());
                builder.append("\t\tRequiredType\t" + type + "\n");
                QValueConstraint[] vca = aPd.getValueConstraints();
                StringBuffer constraints = new StringBuffer();
                if (vca == null) {
                    constraints.append("<null>");
                } else {
                    for (QValueConstraint aVca : vca) {
                        if (constraints.length() > 0) {
                            constraints.append(", ");
                        }
                        constraints.append(aVca.getString());
                    }
                }
                builder.append("\t\tValueConstraints\t" + constraints + "\n");
                QValue[] defVals = aPd.getDefaultValues();
                StringBuffer defaultValues = new StringBuffer();
                if (defVals == null) {
                    defaultValues.append("<null>");
                } else {
                    for (QValue defVal : defVals) {
                        if (defaultValues.length() > 0) {
                            defaultValues.append(", ");
                        }
                        defaultValues.append(defVal.toString());
                    }
                }
                builder.append("\t\tDefaultValue\t" + defaultValues + "\n");
                builder.append("\t\tAutoCreated\t" + aPd.isAutoCreated() + "\n");
                builder.append("\t\tMandatory\t" + aPd.isMandatory() + "\n");
                builder.append("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)aPd.getOnParentVersion()) + "\n");
                builder.append("\t\tProtected\t" + aPd.isProtected() + "\n");
                builder.append("\t\tMultiple\t" + aPd.isMultiple() + "\n");
            }
            for (QNodeDefinition aNd : nd = ntd.getChildNodeDefs()) {
                Name defPrimaryType;
                builder.append("\tNodeDefinition\\n");
                builder.append(" (declared in " + aNd.getDeclaringNodeType() + ")\\n");
                builder.append("\t\tName\t\t" + (aNd.definesResidual() ? "*" : aNd.getName().toString()) + "\n");
                Name[] reqPrimaryTypes = aNd.getRequiredPrimaryTypes();
                if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                    for (Name reqPrimaryType : reqPrimaryTypes) {
                        builder.append("\t\tRequiredPrimaryType\t" + reqPrimaryType + "\n");
                    }
                }
                if ((defPrimaryType = aNd.getDefaultPrimaryType()) != null) {
                    builder.append("\n\t\tDefaultPrimaryType\t" + defPrimaryType + "\n");
                }
                builder.append("\n\t\tAutoCreated\t" + aNd.isAutoCreated() + "\n");
                builder.append("\t\tMandatory\t" + aNd.isMandatory() + "\n");
                builder.append("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)aNd.getOnParentVersion()) + "\n");
                builder.append("\t\tProtected\t" + aNd.isProtected() + "\n");
                builder.append("\t\tAllowsSameNameSiblings\t" + aNd.allowsSameNameSiblings() + "\n");
            }
        }
        builder.append(this.entCache);
        return builder.toString();
    }

    @Override
    public void externalRegistered(Collection<QNodeTypeDefinition> ntDefs) throws RepositoryException, InvalidNodeTypeDefException {
        this.registerNodeTypes(ntDefs, true);
    }

    @Override
    public void externalReregistered(QNodeTypeDefinition ntDef) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        this.reregisterNodeType(ntDef, true);
    }

    @Override
    public void externalUnregistered(Collection<Name> ntNames) throws RepositoryException, NoSuchNodeTypeException {
        this.unregisterNodeTypes(ntNames, true);
    }

    public NodeTypeRegistry(NamespaceRegistry nsReg, FileSystem fs) throws RepositoryException {
        this.nsReg = nsReg;
        this.customNodeTypesResource = new FileSystemResource(fs, CUSTOM_NODETYPES_RESOURCE_NAME);
        try {
            if (!this.customNodeTypesResource.exists()) {
                this.customNodeTypesResource.makeParentDirs();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: invalid resource: " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        this.entCache = new BitSetENTCacheImpl();
        this.registeredNTDefs = new ConcurrentReaderHashMap();
        this.rootNodeDef = NodeTypeRegistry.createRootNodeDef();
        this.builtInNTDefs = new NodeTypeDefStore();
        try {
            this.loadBuiltInNodeTypeDefs(this.builtInNTDefs);
            this.internalRegister(this.builtInNTDefs.all(), true);
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
        this.customNTDefs = new NodeTypeDefStore();
        this.loadCustomNodeTypeDefs(this.customNTDefs);
        try {
            this.internalRegister(this.customNTDefs.all());
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(BUILTIN_NODETYPES_RESOURCE_PATH);
            if (in != null) {
                InputStreamReader r = new InputStreamReader(in, "utf-8");
                store.loadCND(r, BUILTIN_NODETYPES_RESOURCE_PATH);
            }
        }
        catch (IOException ioe) {
            try {
                String error = "internal error: failed to read built-in node type definitions stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
                catch (InvalidNodeTypeDefException intde) {
                    error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.cnd";
                    log.debug(error);
                    throw new RepositoryException(error, (Throwable)intde);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    protected void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            if (this.customNodeTypesResource.exists()) {
                in = this.customNodeTypesResource.getInputStream();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to access custom node type definitions stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        if (in == null) {
            log.info("no custom node type definitions found");
        } else {
            try {
                store.load(in);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to read custom node type definitions stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
            }
            catch (InvalidNodeTypeDefException intde) {
                String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)intde);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        try {
            OutputStream out = this.customNodeTypesResource.getOutputStream();
            try {
                store.store(out, this.nsReg);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)ioe);
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
    }

    protected void checkForConflictingContent(QNodeTypeDefinition ntd) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    protected void checkForReferencesInContent(Name nodeTypeName) throws RepositoryException {
    }

    public QNodeDefinition getRootNodeDef() {
        return this.rootNodeDef;
    }

    public void setEventChannel(NodeTypeEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    static EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        QNodeTypeDefinition ntd = ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (NodeTypeConflictException ntce) {
                String msg = "internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, (Throwable)ntce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (Name ntName : ntNames) {
            if (ntdCache.containsKey(ntName)) continue;
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeType result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                Name[] remainder;
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeType ent = entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                for (Name aRemainder : remainder = key.getNames()) {
                    QNodeTypeDefinition ntd = ntdCache.get(aRemainder);
                    EffectiveNodeType ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = ent;
                        continue;
                    }
                    result = result.merge(ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    static void checkForCircularInheritance(Name[] supertypes, Stack<Name> inheritanceChain, Map<Name, QNodeTypeDefinition> ntDefCache) throws InvalidNodeTypeDefException, RepositoryException {
        for (Name nt : supertypes) {
            int pos = inheritanceChain.lastIndexOf(nt);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < inheritanceChain.size(); ++j) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                }
                buf.append("--> ");
                buf.append(nt);
                throw new InvalidNodeTypeDefException("circular inheritance detected: " + buf.toString());
            }
            try {
                QNodeTypeDefinition ntd = ntDefCache.get(nt);
                Name[] sta = ntd.getSupertypes();
                if (sta.length <= 0) continue;
                inheritanceChain.push(nt);
                NodeTypeRegistry.checkForCircularInheritance(sta, inheritanceChain, ntDefCache);
                inheritanceChain.pop();
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "unknown supertype: " + nt;
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    static void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack<Name> definingParentNTs, EffectiveNodeTypeCache anEntCache, Map<Name, QNodeTypeDefinition> ntDefCache) throws InvalidNodeTypeDefException {
        QNodeDefinition[] nodeDefs;
        Name[] childNodeNTs;
        for (Name nt : childNodeNTs = childNodeENT.getAllNodeTypes()) {
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos < 0) continue;
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < definingParentNTs.size(); ++j) {
                if (j == pos) {
                    buf.append("--> ");
                }
                buf.append("node type ");
                buf.append(definingParentNTs.get(j));
                buf.append(" defines auto-created child node with default ");
            }
            buf.append("--> ");
            buf.append("node type ");
            buf.append(nt);
            throw new InvalidNodeTypeDefException("circular node auto-creation detected: " + buf.toString());
        }
        for (QNodeDefinition nodeDef : nodeDefs = childNodeENT.getAutoCreateNodeDefs()) {
            Name dnt = nodeDef.getDefaultPrimaryType();
            Name definingNT = nodeDef.getDeclaringNodeType();
            try {
                if (dnt == null) continue;
                definingParentNTs.push(definingNT);
                NodeTypeRegistry.checkForCircularNodeAutoCreation(NodeTypeRegistry.getEffectiveNodeType(dnt, anEntCache, ntDefCache), definingParentNTs, anEntCache, ntDefCache);
                definingParentNTs.pop();
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDef.getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    private EffectiveNodeType internalRegister(QNodeTypeDefinition ntd) throws InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (name != null && this.registeredNTDefs.containsKey(name)) {
            String msg = name + " already exists";
            log.debug(msg);
            throw new InvalidNodeTypeDefException(msg);
        }
        ntd = NodeTypeRegistry.checkNtBaseSubtyping(ntd, this.registeredNTDefs);
        EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, this.registeredNTDefs, this.nsReg, false);
        this.entCache.put(ent);
        this.registeredNTDefs.put(name, ntd);
        return ent;
    }

    private void internalRegister(Collection<QNodeTypeDefinition> ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs, false);
    }

    private void internalRegister(Collection<QNodeTypeDefinition> ntDefs, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        ArrayList<QNodeTypeDefinition> defs = new ArrayList<QNodeTypeDefinition>(ntDefs);
        HashMap<Name, QNodeTypeDefinition> tmpNTDefCache = new HashMap<Name, QNodeTypeDefinition>(this.registeredNTDefs);
        for (QNodeTypeDefinition ntd : defs) {
            Name name = ntd.getName();
            if (name != null && tmpNTDefCache.containsKey(name)) {
                String msg = name + " already exists";
                if (tmpNTDefCache.containsKey(name)) {
                    msg = msg + " locally";
                }
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            tmpNTDefCache.put(ntd.getName(), ntd);
        }
        for (int i = 0; i < defs.size(); ++i) {
            QNodeTypeDefinition ntd;
            ntd = (QNodeTypeDefinition)defs.get(i);
            QNodeTypeDefinition mod = NodeTypeRegistry.checkNtBaseSubtyping(ntd, tmpNTDefCache);
            if (mod == ntd) continue;
            tmpNTDefCache.put(mod.getName(), mod);
            defs.set(i, mod);
        }
        EffectiveNodeTypeCache tmpENTCache = (EffectiveNodeTypeCache)this.entCache.clone();
        for (QNodeTypeDefinition ntd : defs) {
            EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, tmpENTCache, tmpNTDefCache, this.nsReg, lenient);
            tmpENTCache.put(ent);
        }
        for (QNodeTypeDefinition ntd : defs) {
            this.registeredNTDefs.put(ntd.getName(), ntd);
        }
        this.entCache = tmpENTCache;
    }

    private void internalUnregister(Name name) throws NoSuchNodeTypeException {
        QNodeTypeDefinition ntd = this.registeredNTDefs.get(name);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
    }

    private void internalUnregister(Collection<Name> ntNames) throws NoSuchNodeTypeException {
        for (Name name : ntNames) {
            this.internalUnregister(name);
        }
    }

    private static void checkNamespace(Name name, NamespaceRegistry nsReg) throws RepositoryException {
        if (name != null) {
            nsReg.getPrefix(name.getNamespaceURI());
        }
    }

    private static QNodeTypeDefinition checkNtBaseSubtyping(QNodeTypeDefinition ntd, Map<Name, QNodeTypeDefinition> ntdCache) {
        boolean modified;
        if (NameConstants.NT_BASE.equals(ntd.getName())) {
            return ntd;
        }
        TreeSet<Name> supertypes = new TreeSet<Name>(Arrays.asList(ntd.getSupertypes()));
        if (supertypes.isEmpty()) {
            return ntd;
        }
        if (ntd.isMixin()) {
            modified = supertypes.remove(NameConstants.NT_BASE);
        } else {
            boolean allMixins = true;
            for (Name name : supertypes) {
                QNodeTypeDefinition def;
                if (name.equals(NameConstants.NT_BASE) || (def = ntdCache.get(name)) == null || def.isMixin()) continue;
                allMixins = false;
                break;
            }
            modified = allMixins ? supertypes.add(NameConstants.NT_BASE) : supertypes.remove(NameConstants.NT_BASE);
        }
        if (modified) {
            ntd = new QNodeTypeDefinitionImpl(ntd.getName(), supertypes.toArray(new Name[supertypes.size()]), ntd.getSupportedMixinTypes(), ntd.isMixin(), ntd.isAbstract(), ntd.isQueryable(), ntd.hasOrderableChildNodes(), ntd.getPrimaryItemName(), ntd.getPropertyDefs(), ntd.getChildNodeDefs());
        }
        return ntd;
    }

    private static EffectiveNodeType validateNodeTypeDef(QNodeTypeDefinition ntd, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache, NamespaceRegistry nsReg, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        QNodeDefinition[] cnda;
        String msg;
        QPropertyDefinition[] pda;
        EffectiveNodeType ent = null;
        Name name = ntd.getName();
        if (name == null) {
            String msg2 = "no name specified";
            log.debug(msg2);
            throw new InvalidNodeTypeDefException(msg2);
        }
        NodeTypeRegistry.checkNamespace(name, nsReg);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            for (Name supertype : supertypes) {
                NodeTypeRegistry.checkNamespace(supertype, nsReg);
                if (name.equals(supertype)) {
                    String msg3 = "[" + name + "] invalid supertype: " + supertype + " (infinite recursion))";
                    log.debug(msg3);
                    throw new InvalidNodeTypeDefException(msg3);
                }
                if (ntdCache.containsKey(supertype)) continue;
                String msg4 = "[" + name + "] invalid supertype: " + supertype;
                log.debug(msg4);
                throw new InvalidNodeTypeDefException(msg4);
            }
            Stack<Name> inheritanceChain = new Stack<Name>();
            inheritanceChain.push(name);
            NodeTypeRegistry.checkForCircularInheritance(supertypes, inheritanceChain, ntdCache);
        }
        if (supertypes.length > 0) {
            try {
                EffectiveNodeType est = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
                if (ntd.getPrimaryItemName() != null && est.getPrimaryItemName() != null) {
                    String msg5 = "[" + name + "] primaryItemName is already specified by a supertype and must therefore not be overridden.";
                    log.debug(msg5);
                    throw new InvalidNodeTypeDefException(msg5);
                }
            }
            catch (NodeTypeConflictException ntce) {
                String msg6 = "[" + name + "] failed to validate supertypes";
                log.debug(msg6);
                throw new InvalidNodeTypeDefException(msg6, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg7 = "[" + name + "] failed to validate supertypes";
                log.debug(msg7);
                throw new InvalidNodeTypeDefException(msg7, nsnte);
            }
        }
        NodeTypeRegistry.checkNamespace(ntd.getPrimaryItemName(), nsReg);
        for (QPropertyDefinition pd : pda = ntd.getPropertyDefs()) {
            QValueConstraint[] constraints;
            String msg2;
            if (!name.equals(pd.getDeclaringNodeType())) {
                String msg8 = "[" + name + "#" + pd.getName() + "] invalid declaring node type specified";
                log.debug(msg8);
                throw new InvalidNodeTypeDefException(msg8);
            }
            NodeTypeRegistry.checkNamespace(pd.getName(), nsReg);
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a name";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a type";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            QValue[] defVals = pd.getDefaultValues();
            if (defVals != null && defVals.length != 0) {
                int reqType = pd.getRequiredType();
                for (QValue qValue : defVals) {
                    if (reqType == 0) {
                        reqType = qValue.getType();
                        continue;
                    }
                    if (qValue.getType() == reqType) continue;
                    String msg9 = "[" + name + "#" + pd.getName() + "] type of default value(s) is not consistent with required property type";
                    log.debug(msg9);
                    throw new InvalidNodeTypeDefException(msg9);
                }
            } else if (!lenient && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created property must have a default value";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if ((constraints = pd.getValueConstraints()) == null || constraints.length <= 0) continue;
            if (defVals != null && defVals.length > 0) {
                for (QValue qValue : defVals) {
                    boolean satisfied = false;
                    ConstraintViolationException cve = null;
                    for (QValueConstraint constraint : constraints) {
                        try {
                            constraint.check(qValue);
                            satisfied = true;
                            break;
                        }
                        catch (ConstraintViolationException e) {
                            cve = e;
                        }
                    }
                    if (satisfied) continue;
                    String msg10 = "[" + name + "#" + pd.getName() + "] default value does not satisfy value constraint";
                    log.debug(msg10);
                    throw new InvalidNodeTypeDefException(msg10, cve);
                }
            }
            if (pd.getRequiredType() != 9 && pd.getRequiredType() != 10) continue;
            for (QValue qValue : constraints) {
                Name ntName = NameFactoryImpl.getInstance().create(qValue.getString());
                if (name.equals(ntName) || ntdCache.containsKey(ntName)) continue;
                String msg11 = "[" + name + "#" + pd.getName() + "] invalid " + (pd.getRequiredType() == 9 ? "REFERENCE" : "WEAKREFERENCE") + " value constraint '" + ntName + "' (unknown node type)";
                log.debug(msg11);
                throw new InvalidNodeTypeDefException(msg11);
            }
        }
        for (QNodeDefinition cnd : cnda = ntd.getChildNodeDefs()) {
            Name[] reqTypes;
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg = "[" + name + "#" + cnd.getName() + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            NodeTypeRegistry.checkNamespace(cnd.getName(), nsReg);
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            Name dpt = cnd.getDefaultPrimaryType();
            NodeTypeRegistry.checkNamespace(dpt, nsReg);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !ntdCache.containsKey(dpt)) {
                    String msg13 = "[" + name + "#" + cnd.getName() + "] invalid default primary type '" + dpt + "'";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefException(msg13);
                }
                try {
                    defaultENT = !referenceToSelf ? NodeTypeRegistry.getEffectiveNodeType(dpt, entCache, ntdCache) : (ent = EffectiveNodeType.create(ntd, entCache, ntdCache));
                    if (cnd.isAutoCreated()) {
                        Stack<Name> definingNTs = new Stack<Name>();
                        definingNTs.push(name);
                        NodeTypeRegistry.checkForCircularNodeAutoCreation(defaultENT, definingNTs, entCache, ntdCache);
                    }
                }
                catch (NodeTypeConflictException ntce) {
                    String string = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(string);
                    throw new InvalidNodeTypeDefException(string, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String string = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(string);
                    throw new InvalidNodeTypeDefException(string, nsnte);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) == null || reqTypes.length <= 0) continue;
            for (Name rpt : reqTypes) {
                if (NameConstants.NT_BASE.equals(rpt)) continue;
                NodeTypeRegistry.checkNamespace(rpt, nsReg);
                referenceToSelf = false;
                if (name.equals(rpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(rpt) && !ntdCache.containsKey(rpt)) {
                    String msg14 = "[" + name + "#" + cnd.getName() + "] invalid required primary type: " + rpt;
                    log.debug(msg14);
                    throw new InvalidNodeTypeDefException(msg14);
                }
                if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                    String msg15 = "[" + name + "#" + cnd.getName() + "] default primary type does not satisfy required primary type constraint " + rpt;
                    log.debug(msg15);
                    throw new InvalidNodeTypeDefException(msg15);
                }
                try {
                    if (!referenceToSelf) {
                        NodeTypeRegistry.getEffectiveNodeType(rpt, entCache, ntdCache);
                        continue;
                    }
                    if (ent != null) continue;
                    ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                }
                catch (NodeTypeConflictException ntce) {
                    String msg16 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg16);
                    throw new InvalidNodeTypeDefException(msg16, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg17 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg17);
                    throw new InvalidNodeTypeDefException(msg17, nsnte);
                }
            }
        }
        if (ent == null) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
            }
            catch (NodeTypeConflictException ntce) {
                String msg18 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg18);
                throw new InvalidNodeTypeDefException(msg18, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg19 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg19);
                throw new InvalidNodeTypeDefException(msg19, nsnte);
            }
        }
        return ent;
    }

    private static QNodeDefinition createRootNodeDef() {
        QNodeDefinitionBuilder def = new QNodeDefinitionBuilder();
        def.setDeclaringNodeType(NameConstants.REP_ROOT);
        def.setRequiredPrimaryTypes(new Name[]{NameConstants.REP_ROOT});
        def.setDefaultPrimaryType(NameConstants.REP_ROOT);
        def.setMandatory(true);
        def.setProtected(false);
        def.setOnParentVersion(2);
        def.setAllowsSameNameSiblings(false);
        def.setAutoCreated(true);
        return def.build();
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Collection<Name> names) {
        NodeTypeRegistryListener[] la;
        for (NodeTypeRegistryListener aLa : la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()])) {
            if (aLa == null) continue;
            aLa.nodeTypesUnregistered(names);
        }
    }
}

