/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DefaultRecordProducer;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.journal.RecordProducer;
import org.apache.jackrabbit.core.util.XAReentrantWriterPreferenceReadWriteLock;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJournal
implements Journal {
    private static Logger log = LoggerFactory.getLogger(AbstractJournal.class);
    private String id;
    private NamespaceResolver resolver;
    private NamePathResolver npResolver;
    private final Map<String, RecordConsumer> consumers = new HashMap<String, RecordConsumer>();
    private final Map<String, RecordProducer> producers = new HashMap<String, RecordProducer>();
    private final XAReentrantWriterPreferenceReadWriteLock rwLock = new XAReentrantWriterPreferenceReadWriteLock();
    private String revision;
    private File repHome;
    private InternalVersionManagerImpl internalVersionManager;

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        this.id = id;
        this.resolver = resolver;
        this.npResolver = new DefaultNamePathResolver(resolver, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RecordConsumer consumer) throws JournalException {
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            if (this.consumers.containsKey(consumerId)) {
                String msg = "Record consumer with identifier '" + consumerId + "' already registered.";
                throw new JournalException(msg);
            }
            this.consumers.put(consumerId, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(RecordConsumer consumer) {
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            return this.consumers.remove(consumerId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConsumer getConsumer(String identifier) {
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            return this.consumers.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordProducer getProducer(String identifier) {
        Map<String, RecordProducer> map = this.producers;
        synchronized (map) {
            RecordProducer producer = this.producers.get(identifier);
            if (producer == null) {
                producer = this.createProducer(identifier);
                this.producers.put(identifier, producer);
            }
            return producer;
        }
    }

    protected RecordProducer createProducer(String identifier) {
        return new DefaultRecordProducer(this, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMinimalRevision() {
        long minimalRevision = Long.MAX_VALUE;
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            for (RecordConsumer consumer : this.consumers.values()) {
                if (consumer.getRevision() >= minimalRevision) continue;
                minimalRevision = consumer.getRevision();
            }
        }
        return minimalRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws JournalException {
        if (this.internalVersionManager != null) {
            VersioningLock.ReadLock lock = this.internalVersionManager.acquireReadLock();
            try {
                this.internalSync();
            }
            finally {
                lock.release();
            }
        } else {
            this.internalSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSync() throws JournalException {
        try {
            this.rwLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire read lock.";
            throw new JournalException(msg, e);
        }
        try {
            this.doSync(this.getMinimalRevision());
        }
        finally {
            this.rwLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long startRevision) throws JournalException {
        RecordIterator iterator = this.getRecords(startRevision);
        long stopRevision = Long.MIN_VALUE;
        try {
            while (iterator.hasNext()) {
                Record record = iterator.nextRecord();
                if (record.getJournalId().equals(this.id)) {
                    log.info("Record with revision '" + record.getRevision() + "' created by this journal, skipped.");
                } else {
                    RecordConsumer consumer = this.getConsumer(record.getProducerId());
                    if (consumer != null) {
                        try {
                            consumer.consume(record);
                        }
                        catch (IllegalStateException e) {
                            log.error("Could not synchronize to revision: " + record.getRevision() + " due illegal state of RecordConsumer.");
                            iterator.close();
                            return;
                        }
                    }
                }
                stopRevision = record.getRevision();
            }
        }
        finally {
            iterator.close();
        }
        if (stopRevision > 0L) {
            for (RecordConsumer consumer : this.consumers.values()) {
                consumer.setRevision(stopRevision);
            }
            log.info("Synchronized to revision: " + stopRevision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAndSync() throws JournalException {
        if (this.internalVersionManager != null) {
            VersioningLock.ReadLock lock = this.internalVersionManager.acquireReadLock();
            try {
                this.internalLockAndSync();
            }
            finally {
                lock.release();
            }
        } else {
            this.internalLockAndSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalLockAndSync() throws JournalException {
        try {
            this.rwLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire write lock.";
            throw new JournalException(msg, e);
        }
        boolean succeeded = false;
        try {
            this.doLock();
            try {
                this.doSync(this.getMinimalRevision());
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.doUnlock(false);
                }
            }
        }
        finally {
            if (!succeeded) {
                this.rwLock.writeLock().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(boolean successful) {
        try {
            this.doUnlock(successful);
        }
        finally {
            this.rwLock.writeLock().release();
        }
    }

    protected abstract void doLock() throws JournalException;

    protected void appending(AppendRecord record) {
    }

    protected abstract void append(AppendRecord var1, InputStream var2, int var3) throws JournalException;

    protected abstract void doUnlock(boolean var1);

    public String getId() {
        return this.id;
    }

    public NamespaceResolver getResolver() {
        return this.resolver;
    }

    public NamePathResolver getNamePathResolver() {
        return this.npResolver;
    }

    public void setRepositoryHome(File repHome) {
        this.repHome = repHome;
    }

    public void setInternalVersionManager(InternalVersionManagerImpl internalVersionManager) {
        this.internalVersionManager = internalVersionManager;
    }

    public File getRepositoryHome() {
        return this.repHome;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }
}

