/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.TransformConstants;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;

abstract class CaseTermQuery
extends MultiTermQuery
implements TransformConstants {
    protected final int transform;

    CaseTermQuery(Term term, int transform) {
        super(term);
        this.transform = transform;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseTermEnum(reader);
    }

    private final class CaseTermEnum
    extends FilteredTermEnum {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CaseTermEnum(IndexReader reader) throws IOException {
            final LinkedHashMap<Term, Integer> orderedTerms = new LinkedHashMap<Term, Integer>();
            Term term = CaseTermQuery.this.getTerm();
            ArrayList<RangeScan> rangeScans = new ArrayList<RangeScan>(2);
            int nameLength = FieldNames.getNameLength(term.text());
            String propName = term.text().substring(0, nameLength);
            OffsetCharSequence termText = new OffsetCharSequence(nameLength, term.text());
            OffsetCharSequence currentTerm = new OffsetCharSequence(nameLength, term.text(), CaseTermQuery.this.transform);
            try {
                if (term.text().length() > nameLength) {
                    StringBuffer lowerLimit = new StringBuffer(propName);
                    String string = termText.toString();
                    String upperTermStr = string.toUpperCase();
                    String lowerTermStr = string.toLowerCase();
                    lowerLimit.append(upperTermStr);
                    lowerLimit.setCharAt(nameLength, Character.toLowerCase(lowerLimit.charAt(nameLength)));
                    StringBuffer upperLimit = new StringBuffer(propName);
                    upperLimit.append(lowerTermStr);
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), upperLimit.toString())));
                    lowerLimit = new StringBuffer(propName);
                    lowerLimit.append(upperTermStr);
                    upperLimit = new StringBuffer(propName);
                    upperLimit.append(lowerTermStr);
                    upperLimit.setCharAt(nameLength, Character.toUpperCase(upperLimit.charAt(nameLength)));
                    rangeScans.add(new RangeScan(reader, new Term(term.field(), lowerLimit.toString()), new Term(term.field(), upperLimit.toString())));
                } else {
                    rangeScans.add(new RangeScan(reader, term, term));
                }
                block7: for (TermEnum termEnum : rangeScans) {
                    Term t;
                    while ((t = termEnum.term()) != null) {
                        currentTerm.setBase(t.text());
                        int compare = currentTerm.compareTo(termText);
                        if (compare == 0) {
                            orderedTerms.put(t, termEnum.docFreq());
                        } else if (compare < 0) {
                            // empty if block
                        }
                        if (termEnum.next()) continue;
                        continue block7;
                    }
                }
            }
            finally {
                for (TermEnum termEnum : rangeScans) {
                    try {
                        termEnum.close();
                    }
                    catch (IOException e) {}
                }
            }
            final Iterator it = orderedTerms.keySet().iterator();
            this.setEnum(new TermEnum(){
                private Term current;
                {
                    this.getNext();
                }

                public boolean next() {
                    this.getNext();
                    return this.current != null;
                }

                public Term term() {
                    return this.current;
                }

                public int docFreq() {
                    Integer docFreq = (Integer)orderedTerms.get(this.current);
                    return docFreq != null ? docFreq : 0;
                }

                public void close() {
                }

                private void getNext() {
                    this.current = it.hasNext() ? (Term)it.next() : null;
                }
            });
        }

        protected boolean termCompare(Term term) {
            return true;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return false;
        }
    }

    static final class Lower
    extends CaseTermQuery {
        Lower(Term term) {
            super(term, 1);
        }
    }

    static final class Upper
    extends CaseTermQuery {
        Upper(Term term) {
            super(term, 2);
        }
    }
}

