/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Comparator;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.query.lucene.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueComparator
implements Comparator<Value> {
    @Override
    public int compare(Value a, Value b) {
        try {
            int ta = a.getType();
            int tb = b.getType();
            if (!(ta != 12 && ta != 4 && ta != 3 || tb != 12 && tb != 4 && tb != 3)) {
                return a.getDecimal().compareTo(b.getDecimal());
            }
            if (ta == 5 && tb == 5) {
                return a.getDate().compareTo(b.getDate());
            }
            return a.getString().compareTo(b.getString());
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare values " + a + " and " + b, e);
        }
    }

    public boolean evaluate(String operator, Value a, Value b) {
        if ("jcr.operator.equal.to".equals(operator)) {
            return this.compare(a, b) == 0;
        }
        if ("jcr.operator.greater.than".equals(operator)) {
            return this.compare(a, b) > 0;
        }
        if ("jcr.operator.greater.than.or.equal.to".equals(operator)) {
            return this.compare(a, b) >= 0;
        }
        if ("jcr.operator.less.than".equals(operator)) {
            return this.compare(a, b) < 0;
        }
        if ("jcr.operator.less.than.or.equal.to".equals(operator)) {
            return this.compare(a, b) <= 0;
        }
        if ("jcr.operator.not.equal.to".equals(operator)) {
            return this.compare(a, b) != 0;
        }
        if ("jcr.operator.like".equals(operator)) {
            try {
                Pattern pattern = Util.createRegexp(b.getString());
                return pattern.matcher(a.getString()).matches();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to compare values " + a + " and " + b, e);
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator: " + operator);
    }

    public boolean evaluate(String operator, Value[] a, Value[] b) {
        if ("jcr.operator.equal.to".equals(operator)) {
            for (int i = 0; i < a.length; ++i) {
                for (int j = 0; j < b.length; ++j) {
                    if (this.compare(a[i], b[j]) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

