/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateChangeDispatcher {
    private final Collection<WeakReference<ItemStateListener>> listeners = new CopyOnWriteArrayList<WeakReference<ItemStateListener>>();
    private final Collection<WeakReference<NodeStateListener>> nsListeners = new CopyOnWriteArrayList<WeakReference<NodeStateListener>>();

    public void addListener(ItemStateListener listener) {
        assert (this.getReference(this.listeners, listener) == null);
        this.listeners.add(new WeakReference<ItemStateListener>(listener));
        if (listener instanceof NodeStateListener) {
            NodeStateListener nsListener = (NodeStateListener)listener;
            assert (this.getReference(this.nsListeners, nsListener) == null);
            this.nsListeners.add(new WeakReference<NodeStateListener>(nsListener));
        }
    }

    private <T> Reference<T> getReference(Collection<? extends Reference<T>> coll, ItemStateListener listener) {
        for (Reference<T> ref : coll) {
            T o = ref.get();
            if (o == listener) {
                return ref;
            }
            if (o != null) continue;
            coll.remove(ref);
        }
        return null;
    }

    public void removeListener(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            this.nsListeners.remove(this.getReference(this.nsListeners, listener));
        }
        this.listeners.remove(this.getReference(this.listeners, listener));
    }

    public void notifyStateCreated(ItemState created) {
        for (Reference reference : this.listeners) {
            ItemStateListener l = (ItemStateListener)reference.get();
            if (l == null) continue;
            l.stateCreated(created);
        }
    }

    public void notifyStateModified(ItemState modified) {
        for (Reference reference : this.listeners) {
            ItemStateListener l = (ItemStateListener)reference.get();
            if (l == null) continue;
            l.stateModified(modified);
        }
    }

    public void notifyStateDestroyed(ItemState destroyed) {
        for (Reference reference : this.listeners) {
            ItemStateListener l = (ItemStateListener)reference.get();
            if (l == null) continue;
            l.stateDestroyed(destroyed);
        }
    }

    public void notifyStateDiscarded(ItemState discarded) {
        for (Reference reference : this.listeners) {
            ItemStateListener l = (ItemStateListener)reference.get();
            if (l == null) continue;
            l.stateDiscarded(discarded);
        }
    }

    public void notifyNodeAdded(NodeState state, Name name, int index, NodeId id) {
        for (Reference reference : this.nsListeners) {
            NodeStateListener n = (NodeStateListener)reference.get();
            if (n == null) continue;
            n.nodeAdded(state, name, index, id);
        }
    }

    public void notifyNodesReplaced(NodeState state) {
        for (Reference reference : this.nsListeners) {
            NodeStateListener n = (NodeStateListener)reference.get();
            if (n == null) continue;
            n.nodesReplaced(state);
        }
    }

    public void notifyNodeModified(NodeState state) {
        for (Reference reference : this.nsListeners) {
            NodeStateListener n = (NodeStateListener)reference.get();
            if (n == null) continue;
            n.nodeModified(state);
        }
    }

    public void notifyNodeRemoved(NodeState state, Name name, int index, NodeId id) {
        for (Reference reference : this.nsListeners) {
            NodeStateListener n = (NodeStateListener)reference.get();
            if (n == null) continue;
            n.nodeRemoved(state, name, index, id);
        }
    }
}

