/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.JackrabbitPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EveryonePrincipal
implements Group,
JackrabbitPrincipal {
    public static final String NAME = "everyone";
    private static final EveryonePrincipal INSTANCE = new EveryonePrincipal();

    private EveryonePrincipal() {
    }

    public static EveryonePrincipal getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return NAME;
    }

    public boolean addMember(Principal user) {
        return false;
    }

    public boolean removeMember(Principal user) {
        throw new UnsupportedOperationException("Cannot remove a member from the everyone group.");
    }

    public boolean isMember(Principal member) {
        return !((Object)member).equals(this);
    }

    public Enumeration<? extends Principal> members() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int hashCode() {
        return NAME.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this || obj instanceof EveryonePrincipal) {
            return true;
        }
        if (obj instanceof JackrabbitPrincipal) {
            return NAME.equals(((JackrabbitPrincipal)obj).getName());
        }
        return false;
    }
}

