/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.core.jmx.TimeSeriesMBean;

public class TimeSeriesRecorder
implements TimeSeriesMBean {
    private final long[] eventsPerSecond = new long[60];
    private final long[] eventsPerMinute = new long[60];
    private final long[] eventsPerHour = new long[168];
    private final long[] eventsPerWeek = new long[156];
    private int seconds = 0;
    private int minutes = 0;
    private int hours = 0;
    private int weeks = 0;

    public TimeSeriesRecorder(final AtomicLong counter, ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ((TimeSeriesRecorder)TimeSeriesRecorder.this).eventsPerSecond[((TimeSeriesRecorder)TimeSeriesRecorder.this).seconds++] = counter.getAndSet(0L);
                if (TimeSeriesRecorder.this.seconds == TimeSeriesRecorder.this.eventsPerSecond.length) {
                    TimeSeriesRecorder.this.seconds = 0;
                    ((TimeSeriesRecorder)TimeSeriesRecorder.this).eventsPerMinute[((TimeSeriesRecorder)TimeSeriesRecorder.this).minutes++] = TimeSeriesRecorder.sum(TimeSeriesRecorder.this.eventsPerSecond);
                }
                if (TimeSeriesRecorder.this.minutes == TimeSeriesRecorder.this.eventsPerMinute.length) {
                    TimeSeriesRecorder.this.minutes = 0;
                    ((TimeSeriesRecorder)TimeSeriesRecorder.this).eventsPerHour[((TimeSeriesRecorder)TimeSeriesRecorder.this).hours++] = TimeSeriesRecorder.sum(TimeSeriesRecorder.this.eventsPerMinute);
                }
                if (TimeSeriesRecorder.this.hours == TimeSeriesRecorder.this.eventsPerHour.length) {
                    TimeSeriesRecorder.this.hours = 0;
                    ((TimeSeriesRecorder)TimeSeriesRecorder.this).eventsPerWeek[((TimeSeriesRecorder)TimeSeriesRecorder.this).weeks++] = TimeSeriesRecorder.sum(TimeSeriesRecorder.this.eventsPerHour);
                }
                if (TimeSeriesRecorder.this.weeks == TimeSeriesRecorder.this.eventsPerWeek.length) {
                    TimeSeriesRecorder.this.weeks = 0;
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public synchronized long[] getEventsPerSecond() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.eventsPerSecond, this.seconds);
    }

    public synchronized long[] getEventsPerMinute() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.eventsPerMinute, this.minutes);
    }

    public synchronized long[] getEventsPerHour() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.eventsPerHour, this.hours);
    }

    public synchronized long[] getEventsPerWeek() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.eventsPerWeek, this.weeks);
    }

    private static long sum(long[] array) {
        long sum = 0L;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    private static long[] cyclicCopyFrom(long[] array, int pos) {
        long[] reverse = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverse[i] = array[(pos + i) % array.length];
        }
        return reverse;
    }
}

