/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.query;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class QueryStatDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long position;
    private final Date creationTime;
    private final long duration;
    private final String language;
    private final String statement;

    public QueryStatDto(String language, String statement, long duration) {
        this.duration = duration;
        this.language = language;
        this.statement = statement;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis() - duration);
        this.creationTime = c.getTime();
    }

    public long getDuration() {
        return this.duration;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getCreationTime() {
        return this.creationTime.toString();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public String toString() {
        return "QueryStat [creationTime=" + this.creationTime + ", duration=" + this.duration + ", language=" + this.language + ", statement=" + this.statement + "]";
    }
}

