/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.query;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.jackrabbit.core.jmx.query.QueryStat;
import org.apache.jackrabbit.core.jmx.query.QueryStatDto;
import org.apache.jackrabbit.core.jmx.query.QueryStatDtoComparator;
import org.apache.jackrabbit.core.jmx.util.CachingOpsPerSecondDto;

public class QueryStatImpl
implements QueryStat {
    private static final Comparator<QueryStatDto> comparator = new QueryStatDtoComparator();
    private int queueSize = 15;
    private PriorityQueue<QueryStatDto> queries = new PriorityQueue<QueryStatDto>(this.queueSize + 1, comparator);
    private CachingOpsPerSecondDto qps = new CachingOpsPerSecondDto();
    private boolean enabled = false;

    public int getSlowQueriesQueueSize() {
        return this.queueSize;
    }

    public synchronized void setSlowQueriesQueueSize(int size) {
        this.queueSize = size;
        this.queries = new PriorityQueue<QueryStatDto>(this.queueSize + 1, comparator);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.queries = new PriorityQueue<QueryStatDto>(this.queueSize + 1, comparator);
    }

    public synchronized void logQuery(String language, String statement, long duration) {
        if (!this.enabled) {
            return;
        }
        this.queries.add(new QueryStatDto(language, statement, duration));
        if (this.queries.size() > this.queueSize) {
            this.queries.remove();
        }
        this.qps.onOp(duration * 1000L);
    }

    public void clearSlowQueriesQueue() {
        this.queries.clear();
    }

    public void reset() {
        this.clearSlowQueriesQueue();
    }

    public QueryStatDto[] getSlowQueries() {
        return this.queries.toArray(new QueryStatDto[this.queries.size()]);
    }

    public double getQueriesPerSecond() {
        return this.qps.getOpsPerSecond();
    }

    public double getAvgQueryTime() {
        return this.qps.getOpAvgTime();
    }
}

