/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.core.jmx.query.QueryStat;
import org.apache.jackrabbit.core.jmx.query.QueryStatDto;
import org.apache.jackrabbit.core.jmx.query.QueryStatDtoComparator;
import org.apache.jackrabbit.core.jmx.query.QueryStatManagerMBean;

public class QueryStatManager
implements QueryStatManagerMBean {
    private final QueryStat queryStat;
    private static final Comparator<QueryStatDto> comparatorRev = Collections.reverseOrder(new QueryStatDtoComparator());

    public QueryStatManager(QueryStat queryStat) {
        this.queryStat = queryStat;
    }

    public boolean isEnabled() {
        return this.queryStat.isEnabled();
    }

    public void enable() {
        this.queryStat.setEnabled(true);
    }

    public void disable() {
        this.queryStat.setEnabled(false);
    }

    public void reset() {
        this.queryStat.reset();
    }

    public int getQueueSize() {
        return this.queryStat.getSlowQueriesQueueSize();
    }

    public void setQueueSize(int size) {
        this.queryStat.setSlowQueriesQueueSize(size);
    }

    public void clearQueue() {
        this.queryStat.clearSlowQueriesQueue();
    }

    public QueryStatDto[] getTopQueries() {
        QueryStatDto[] top = this.queryStat.getSlowQueries();
        Arrays.sort(top, comparatorRev);
        for (int i = 0; i < top.length; ++i) {
            top[i].setPosition(i + 1);
        }
        return top;
    }

    public TabularData getQueries() {
        TabularDataSupport tds = null;
        try {
            CompositeType ct = QueryStatCompositeTypeFactory.getCompositeType();
            TabularType tt = new TabularType(QueryStatDto.class.getName(), "Query History", ct, QueryStatCompositeTypeFactory.index);
            tds = new TabularDataSupport(tt);
            for (QueryStatDto q : this.getTopQueries()) {
                tds.put(new CompositeDataSupport(ct, QueryStatCompositeTypeFactory.names, QueryStatCompositeTypeFactory.getValues(q)));
            }
            return tds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class QueryStatCompositeTypeFactory {
        private static final String[] index = new String[]{"position"};
        private static final String[] names = new String[]{"position", "duration", "language", "statement", "creationTime"};
        private static final String[] descriptions = new String[]{"position", "duration", "language", "statement", "creationTime"};
        private static final OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

        private QueryStatCompositeTypeFactory() {
        }

        public static CompositeType getCompositeType() throws OpenDataException {
            return new CompositeType(QueryStat.class.getName(), QueryStat.class.getName(), names, descriptions, types);
        }

        public static Object[] getValues(QueryStatDto q) {
            return new Object[]{q.getPosition(), q.getDuration(), q.getLanguage(), q.getStatement(), q.getCreationTime()};
        }
    }
}

