/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachingOpsPerSecondDto {
    public static long DEFAULT_UPDATE_FREQ_MS = 60000L;
    private final long updateFreqMs;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private long lastUpdate = System.currentTimeMillis();
    private long startMs = System.currentTimeMillis();
    private long operations = 0L;
    private long totalTimeNs = 0L;
    private double opsPerSecond = 0.0;
    private double opAvgTime = 0.0;
    private static final BigDecimal thousand = BigDecimal.valueOf(1000L);
    private static final MathContext DEFAULT_CONTEXT = new MathContext(3);

    public CachingOpsPerSecondDto(long updateFreqMs) {
        this.updateFreqMs = updateFreqMs;
    }

    public CachingOpsPerSecondDto() {
        this(DEFAULT_UPDATE_FREQ_MS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOp(long timeNs) {
        this.w.lock();
        try {
            long localStart = System.currentTimeMillis() - timeNs / 1000L;
            if (localStart < this.startMs) {
                this.startMs = localStart;
            }
            ++this.operations;
            this.totalTimeNs += timeNs;
        }
        finally {
            this.w.unlock();
        }
    }

    public double getOpsPerSecond() {
        this.checkUpdate(false);
        return this.opsPerSecond;
    }

    public double getOpAvgTime() {
        this.checkUpdate(false);
        return this.opAvgTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdate(boolean forceUpdate) {
        this.r.lock();
        long now = System.currentTimeMillis();
        try {
            if (!forceUpdate && now - this.lastUpdate < this.updateFreqMs) {
                return;
            }
        }
        finally {
            this.r.unlock();
        }
        this.w.lock();
        try {
            if (!forceUpdate && now - this.lastUpdate < this.updateFreqMs) {
                return;
            }
            this.update(now);
        }
        finally {
            this.w.unlock();
        }
    }

    private void update(long now) {
        if (this.operations == 0L) {
            this.opsPerSecond = 0.0;
            this.opAvgTime = 0.0;
            return;
        }
        long durationMs = now - this.startMs;
        if (durationMs == 0L) {
            durationMs = 1000L;
        }
        this.opsPerSecond = BigDecimal.valueOf(this.operations).multiply(thousand).divide(BigDecimal.valueOf(durationMs), DEFAULT_CONTEXT).doubleValue();
        this.opAvgTime = BigDecimal.valueOf(this.totalTimeNs).divide(BigDecimal.valueOf(this.operations), DEFAULT_CONTEXT).doubleValue();
        if (this.operations > 9223372036854770807L) {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.w.lock();
        try {
            this.opsPerSecond = 0.0;
            this.opAvgTime = 0.0;
            this.lastUpdate = System.currentTimeMillis();
            this.operations = 0L;
            this.startMs = this.lastUpdate;
            this.totalTimeNs = 0L;
        }
        finally {
            this.w.unlock();
        }
    }

    protected void refresh() {
        this.checkUpdate(true);
    }
}

