/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import javax.sql.DataSource;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;

public class OracleDatabaseJournal
extends DatabaseJournal {
    protected static final String DEFAULT_TABLESPACE_CLAUSE = "";
    protected static final String TABLESPACE_VARIABLE = "${tablespace}";
    protected static final String INDEX_TABLESPACE_VARIABLE = "${indexTablespace}";
    protected String tablespace;
    protected String indexTablespace;

    public OracleDatabaseJournal() {
        this.setDatabaseType("oracle");
        this.setDriver("oracle.jdbc.OracleDriver");
        this.setSchemaObjectPrefix(DEFAULT_TABLESPACE_CLAUSE);
        this.tablespace = DEFAULT_TABLESPACE_CLAUSE;
        this.indexTablespace = DEFAULT_TABLESPACE_CLAUSE;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespaceName) {
        this.tablespace = this.buildTablespaceClause(tablespaceName);
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String tablespaceName) {
        this.indexTablespace = this.buildTablespaceClause(tablespaceName);
    }

    private String buildTablespaceClause(String tablespaceName) {
        if (tablespaceName == null || tablespaceName.trim().length() == 0) {
            return DEFAULT_TABLESPACE_CLAUSE;
        }
        return "tablespace " + tablespaceName.trim();
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        OracleConnectionHelper helper = new OracleConnectionHelper(dataSrc, false);
        helper.init();
        return helper;
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        if (DEFAULT_TABLESPACE_CLAUSE.equals(this.indexTablespace) && !DEFAULT_TABLESPACE_CLAUSE.equals(this.tablespace)) {
            this.indexTablespace = this.tablespace;
        }
        return super.createCheckSchemaOperation().addVariableReplacement(TABLESPACE_VARIABLE, this.tablespace).addVariableReplacement(INDEX_TABLESPACE_VARIABLE, this.indexTablespace);
    }
}

