/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.persistence.pool.NGKDbNameIndex;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;

public class OraclePersistenceManager
extends BundleDbPersistenceManager {
    protected static final String DEFAULT_TABLESPACE_CLAUSE = "";
    protected static final String TABLESPACE_VARIABLE = "${tablespace}";
    protected static final String INDEX_TABLESPACE_VARIABLE = "${indexTablespace}";
    protected String tablespace = "";
    protected String indexTablespace = "";

    public OraclePersistenceManager() {
        this.setExternalBLOBs(false);
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespaceName) {
        this.tablespace = this.buildTablespaceClause(tablespaceName);
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String tablespaceName) {
        this.indexTablespace = this.buildTablespaceClause(tablespaceName);
    }

    private String buildTablespaceClause(String tablespaceName) {
        if (tablespaceName == null || tablespaceName.trim().length() == 0) {
            return DEFAULT_TABLESPACE_CLAUSE;
        }
        return "tablespace " + tablespaceName.trim();
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("oracle.jdbc.OracleDriver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe");
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("oracle");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix(context.getHomeDir().getName() + "_");
        }
        super.init(context);
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new NGKDbNameIndex(this.conHelper, this.schemaObjectPrefix);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        OracleConnectionHelper helper = new OracleConnectionHelper(dataSrc, this.blockOnConnectionLoss);
        helper.init();
        return helper;
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        if (DEFAULT_TABLESPACE_CLAUSE.equals(this.indexTablespace) && !DEFAULT_TABLESPACE_CLAUSE.equals(this.tablespace)) {
            this.indexTablespace = this.tablespace;
        }
        return super.createCheckSchemaOperation().addVariableReplacement(TABLESPACE_VARIABLE, this.tablespace).addVariableReplacement(INDEX_TABLESPACE_VARIABLE, this.indexTablespace);
    }
}

