/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

public class JackrabbitAnalyzer
extends Analyzer {
    private Analyzer defaultAnalyzer = new StandardAnalyzer(Version.LUCENE_24, Collections.emptySet());
    private IndexingConfiguration indexingConfig;

    protected void setIndexingConfig(IndexingConfiguration indexingConfig) {
        this.indexingConfig = indexingConfig;
    }

    protected void setDefaultAnalyzer(Analyzer analyzer) {
        this.defaultAnalyzer = analyzer;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.tokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.tokenStream(fieldName, reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.reusableTokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
    }
}

